/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.xpath.impl;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XNamedNodeMap
implements NamedNodeMap {
    public static final XNamedNodeMap EMPTY = new XNamedNodeMap();
    Map<NSName, Node> map = new HashMap<NSName, Node>();
    Node[] cache;

    public Node getNamedItem(String name) {
        return this.map.get(new NSName(name));
    }

    public Node setNamedItem(Node node) throws DOMException {
        this.cache = null;
        NSName name = new NSName(node.getNodeName());
        return this.map.put(name, node);
    }

    public Node removeNamedItem(String name) throws DOMException {
        this.cache = null;
        return this.map.remove(new NSName(name));
    }

    public Node item(int i) {
        if (this.cache == null) {
            this.cache = this.map.values().toArray(new Node[this.map.size()]);
        }
        return this.cache[i];
    }

    public int getLength() {
        return this.map.size();
    }

    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        return this.map.get(new NSName(namespaceURI, localName));
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        this.cache = null;
        NSName name = new NSName(node.getNamespaceURI(), node.getLocalName());
        return this.map.put(name, node);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        this.cache = null;
        NSName name = new NSName(namespaceURI, localName);
        return this.map.remove(name);
    }

    private static class NSName {
        String namespaceURI;
        String localName;
        String name;

        NSName(String ns, String ln) {
            this.namespaceURI = ns;
            this.localName = ln;
        }

        NSName(String nm) {
            this.name = nm;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NSName)) {
                return false;
            }
            NSName other = (NSName)obj;
            return this.localName != null ? this.namespaceURI.equals(other.namespaceURI) && this.localName.equals(other.localName) : this.name.equals(other.name);
        }

        public int hashCode() {
            return this.localName != null ? this.namespaceURI.hashCode() ^ this.localName.hashCode() : this.name.hashCode();
        }
    }
}

