/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.xpath.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.dom4j.Node;
import org.hudsonci.xpath.XFunctionFilter;
import org.hudsonci.xpath.XNamespaceContext;
import org.hudsonci.xpath.XPathAPI;
import org.hudsonci.xpath.XPathException;
import org.hudsonci.xpath.XVariableContext;
import org.hudsonci.xpath.impl.Dom2Dom;
import org.hudsonci.xpath.impl.Pair;
import org.hudsonci.xpath.impl.Rewriter;
import org.w3c.dom.NodeList;

public class XPathJavaImpl
implements XPathAPI {
    String expr;
    String workingExpr;
    XPath xpath;
    XVariableContext varContext;
    XNamespaceContext nsContext;
    XFunctionFilter funFilter;
    XPathExpression xpathExpr;
    private static final Logger LOGGER = Logger.getLogger(XPathJavaImpl.class.getName());
    private Dom2Dom d2d;

    public XPathJavaImpl(String expr) {
        this.expr = expr;
    }

    public void setFunctionFilter(XFunctionFilter filter) {
        LOGGER.warning("xpath-provider plugin required for function filter");
        this.funFilter = filter;
    }

    public XFunctionFilter getFunctionFilter() {
        return this.funFilter;
    }

    private org.w3c.dom.Node nodeToNode(Node d4jNode) throws XPathException {
        this.d2d = new Dom2Dom();
        return this.d2d.dom2Dom(d4jNode, true);
    }

    private Node unmap(org.w3c.dom.Node node) {
        return this.d2d.getOriginalNode(node);
    }

    private XPathExpression getXPathExpression() throws XPathException {
        if (this.xpathExpr == null) {
            XPathFactory factory = XPathFactory.newInstance();
            if (this.varContext != null) {
                factory.setXPathVariableResolver(new VarResolver());
            }
            this.xpath = factory.newXPath();
            if (this.nsContext != null) {
                this.xpath.setNamespaceContext(this.nsContext);
            }
            try {
                this.xpathExpr = this.xpath.compile(this.workingExpr);
            }
            catch (XPathExpressionException ex) {
                throw new XPathException(ex);
            }
        }
        return this.xpathExpr;
    }

    public void setVariableContext(XVariableContext varContext) {
        this.varContext = varContext;
    }

    public XVariableContext getVariableContext() {
        return this.varContext;
    }

    public void setNamespaceContext(XNamespaceContext nsContext) {
        this.nsContext = nsContext;
    }

    public XNamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    private org.w3c.dom.Node getNode(Object xpathContext) throws XPathException {
        this.workingExpr = this.expr;
        Node node = null;
        if (xpathContext instanceof Node) {
            node = (Node)xpathContext;
        } else if (xpathContext == null) {
            try {
                Rewriter rewriter = new Rewriter();
                Pair<String, Node> pair = rewriter.rewriteExpression(this.expr, this.varContext, this.nsContext);
                node = pair.getRight();
                this.workingExpr = pair.getLeft();
            }
            catch (Exception ex) {
                throw new XPathException(ex);
            }
        }
        if (node != null) {
            return this.nodeToNode(node);
        }
        throw new XPathException(xpathContext.getClass().getName() + " xpathContext must be subclass of org.dom4j.Node");
    }

    public Object evaluate(Object xpathContext) throws XPathException {
        org.w3c.dom.Node context = this.getNode(xpathContext);
        XPathExpression xexpr = this.getXPathExpression();
        Object obj = null;
        try {
            obj = xexpr.evaluate(context, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            try {
                obj = xexpr.evaluate(context);
            }
            catch (XPathExpressionException ex1) {
                throw new XPathException(ex1);
            }
        }
        if (obj instanceof NodeList) {
            NodeList list = (NodeList)obj;
            int len = list.getLength();
            if (len == 1) {
                return this.unmap(list.item(0));
            }
            return this.makeList(list);
        }
        String s = ((String)obj).trim();
        if ("true".equals(s)) {
            return Boolean.TRUE;
        }
        if ("false".equals(s)) {
            return Boolean.FALSE;
        }
        Double d = this.tryNumber(s);
        if (d != null) {
            return d;
        }
        return s;
    }

    private Double tryNumber(String s) {
        if ("INF".equals(s) || "+INF".equals(s)) {
            s = "Infinity";
        } else if ("-INF".equals(s)) {
            s = "-Infinity";
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean booleanValueOf(Object xpathContext) throws XPathException {
        Object obj;
        org.w3c.dom.Node context = this.getNode(xpathContext);
        XPathExpression xexpr = this.getXPathExpression();
        try {
            obj = xexpr.evaluate(context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException ex) {
            throw new XPathException(ex);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new XPathException("result not a Boolean, returned " + obj.getClass().getName());
    }

    public double numberValueOf(Object xpathContext) throws XPathException {
        Object obj;
        org.w3c.dom.Node context = this.getNode(xpathContext);
        XPathExpression xexpr = this.getXPathExpression();
        try {
            obj = xexpr.evaluate(context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException ex) {
            throw new XPathException(ex);
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        throw new XPathException("result not a Double, returned " + obj.getClass().getName());
    }

    public String stringValueOf(Object xpathContext) throws XPathException {
        org.w3c.dom.Node context = this.getNode(xpathContext);
        XPathExpression xexpr = this.getXPathExpression();
        try {
            return xexpr.evaluate(xpathContext);
        }
        catch (XPathExpressionException ex) {
            throw new XPathException(ex);
        }
    }

    public Node selectSingleNode(Object xpathContext) throws XPathException {
        Object obj;
        org.w3c.dom.Node context = this.getNode(xpathContext);
        XPathExpression xexpr = this.getXPathExpression();
        try {
            obj = xexpr.evaluate(context, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new XPathException(ex);
        }
        if (obj instanceof org.w3c.dom.Node) {
            return this.unmap((org.w3c.dom.Node)obj);
        }
        if (obj instanceof NodeList) {
            NodeList nodeList = (NodeList)obj;
            if (nodeList.getLength() == 0) {
                throw new XPathException("returned empty NodeList");
            }
            return this.unmap(nodeList.item(0));
        }
        throw new XPathException("result not a node, returned " + (obj == null ? "null" : obj.getClass().getName()));
    }

    public List selectNodes(Object xpathContext) throws XPathException {
        Object obj;
        org.w3c.dom.Node context = this.getNode(xpathContext);
        XPathExpression xexpr = this.getXPathExpression();
        try {
            obj = xexpr.evaluate(context, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            throw new XPathException(ex);
        }
        if (obj instanceof org.w3c.dom.Node) {
            return this.makeList((org.w3c.dom.Node)obj);
        }
        if (obj instanceof NodeList) {
            return this.makeList((NodeList)obj);
        }
        if (obj == null) {
            return Collections.EMPTY_LIST;
        }
        throw new XPathException("result not a node list, returned " + obj.getClass().getName());
    }

    private List makeList(NodeList nodeList) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            nodes.add(this.unmap(nodeList.item(i)));
        }
        return nodes;
    }

    private List makeList(org.w3c.dom.Node node) {
        Node d4jNode = this.unmap(node);
        ArrayList<Node> list = new ArrayList<Node>();
        list.add(d4jNode);
        return list;
    }

    public String toString() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
        this.xpathExpr = null;
    }

    private class VarResolver
    implements XPathVariableResolver {
        private VarResolver() {
        }

        public Object resolveVariable(QName qname) {
            try {
                Object obj = XPathJavaImpl.this.varContext.getVariableValue(qname.getNamespaceURI(), qname.getPrefix(), qname.getLocalPart());
                if (obj instanceof Node) {
                    obj = XPathJavaImpl.this.nodeToNode((Node)obj);
                }
                return obj;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

