/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public class CurrentProcessSummary {
    private int total = 0;
    private int sleeping = 0;
    private int running = 0;
    private int zombie = 0;
    private int stopped = 0;

    private CurrentProcessSummary() {
    }

    public static CurrentProcessSummary get(SigarProxy sigar) throws SigarException {
        long[] pids = sigar.getProcList();
        CurrentProcessSummary summary = new CurrentProcessSummary();
        block8: for (int i = 0; i < pids.length; ++i) {
            ProcState state;
            try {
                state = sigar.getProcState(pids[i]);
            }
            catch (SigarException e) {
                continue;
            }
            ++summary.total;
            switch (state.getState()) {
                case 'R': {
                    ++summary.running;
                    continue block8;
                }
                case 'T': {
                    ++summary.stopped;
                    continue block8;
                }
                case 'S': {
                    ++summary.sleeping;
                    continue block8;
                }
                case 'Z': {
                    ++summary.zombie;
                }
            }
        }
        return summary;
    }

    public int getTotal() {
        return this.total;
    }

    public int getSleeping() {
        return this.sleeping;
    }

    public int getRunning() {
        return this.running;
    }

    public int getZombie() {
        return this.zombie;
    }

    public int getStopped() {
        return this.stopped;
    }

    public String toString() {
        return this.total + " processes: " + this.sleeping + " sleeping, " + this.running + " running, " + this.zombie + " zombie, " + this.stopped + " stopped";
    }
}

