/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class FileSystemUsage
implements Serializable {
    private static final long serialVersionUID = 16298L;
    long total = 0L;
    long free = 0L;
    long used = 0L;
    long avail = 0L;
    long files = 0L;
    long freeFiles = 0L;
    long diskReads = 0L;
    long diskWrites = 0L;
    long diskReadBytes = 0L;
    long diskWriteBytes = 0L;
    long diskQueue = 0L;
    double usePercent = 0.0;

    public native void gather(Sigar var1, String var2) throws SigarException;

    static FileSystemUsage fetch(Sigar sigar, String name) throws SigarException {
        FileSystemUsage fileSystemUsage = new FileSystemUsage();
        fileSystemUsage.gather(sigar, name);
        return fileSystemUsage;
    }

    public long getTotal() {
        return this.total;
    }

    public long getFree() {
        return this.free;
    }

    public long getUsed() {
        return this.used;
    }

    public long getAvail() {
        return this.avail;
    }

    public long getFiles() {
        return this.files;
    }

    public long getFreeFiles() {
        return this.freeFiles;
    }

    public long getDiskReads() {
        return this.diskReads;
    }

    public long getDiskWrites() {
        return this.diskWrites;
    }

    public long getDiskReadBytes() {
        return this.diskReadBytes;
    }

    public long getDiskWriteBytes() {
        return this.diskWriteBytes;
    }

    public long getDiskQueue() {
        return this.diskQueue;
    }

    public double getUsePercent() {
        return this.usePercent;
    }

    void copyTo(FileSystemUsage copy) {
        copy.total = this.total;
        copy.free = this.free;
        copy.used = this.used;
        copy.avail = this.avail;
        copy.files = this.files;
        copy.freeFiles = this.freeFiles;
        copy.diskReads = this.diskReads;
        copy.diskWrites = this.diskWrites;
        copy.diskReadBytes = this.diskReadBytes;
        copy.diskWriteBytes = this.diskWriteBytes;
        copy.diskQueue = this.diskQueue;
        copy.usePercent = this.usePercent;
    }

    public Map toMap() {
        String strusePercent;
        String strdiskQueue;
        String strdiskWriteBytes;
        String strdiskReadBytes;
        String strdiskWrites;
        String strdiskReads;
        String strfreeFiles;
        String strfiles;
        String stravail;
        String strused;
        String strfree;
        HashMap<String, String> map = new HashMap<String, String>();
        String strtotal = String.valueOf(this.total);
        if (!"-1".equals(strtotal)) {
            map.put("Total", strtotal);
        }
        if (!"-1".equals(strfree = String.valueOf(this.free))) {
            map.put("Free", strfree);
        }
        if (!"-1".equals(strused = String.valueOf(this.used))) {
            map.put("Used", strused);
        }
        if (!"-1".equals(stravail = String.valueOf(this.avail))) {
            map.put("Avail", stravail);
        }
        if (!"-1".equals(strfiles = String.valueOf(this.files))) {
            map.put("Files", strfiles);
        }
        if (!"-1".equals(strfreeFiles = String.valueOf(this.freeFiles))) {
            map.put("FreeFiles", strfreeFiles);
        }
        if (!"-1".equals(strdiskReads = String.valueOf(this.diskReads))) {
            map.put("DiskReads", strdiskReads);
        }
        if (!"-1".equals(strdiskWrites = String.valueOf(this.diskWrites))) {
            map.put("DiskWrites", strdiskWrites);
        }
        if (!"-1".equals(strdiskReadBytes = String.valueOf(this.diskReadBytes))) {
            map.put("DiskReadBytes", strdiskReadBytes);
        }
        if (!"-1".equals(strdiskWriteBytes = String.valueOf(this.diskWriteBytes))) {
            map.put("DiskWriteBytes", strdiskWriteBytes);
        }
        if (!"-1".equals(strdiskQueue = String.valueOf(this.diskQueue))) {
            map.put("DiskQueue", strdiskQueue);
        }
        if (!"-1".equals(strusePercent = String.valueOf(this.usePercent))) {
            map.put("UsePercent", strusePercent);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

