/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class NetInterfaceStat
implements Serializable {
    private static final long serialVersionUID = 19079L;
    long rxBytes = 0L;
    long rxPackets = 0L;
    long rxErrors = 0L;
    long rxDropped = 0L;
    long rxOverruns = 0L;
    long rxFrame = 0L;
    long txBytes = 0L;
    long txPackets = 0L;
    long txErrors = 0L;
    long txDropped = 0L;
    long txOverruns = 0L;
    long txCollisions = 0L;
    long txCarrier = 0L;

    public native void gather(Sigar var1, String var2) throws SigarException;

    static NetInterfaceStat fetch(Sigar sigar, String name) throws SigarException {
        NetInterfaceStat netInterfaceStat = new NetInterfaceStat();
        netInterfaceStat.gather(sigar, name);
        return netInterfaceStat;
    }

    public long getRxBytes() {
        return this.rxBytes;
    }

    public long getRxPackets() {
        return this.rxPackets;
    }

    public long getRxErrors() {
        return this.rxErrors;
    }

    public long getRxDropped() {
        return this.rxDropped;
    }

    public long getRxOverruns() {
        return this.rxOverruns;
    }

    public long getRxFrame() {
        return this.rxFrame;
    }

    public long getTxBytes() {
        return this.txBytes;
    }

    public long getTxPackets() {
        return this.txPackets;
    }

    public long getTxErrors() {
        return this.txErrors;
    }

    public long getTxDropped() {
        return this.txDropped;
    }

    public long getTxOverruns() {
        return this.txOverruns;
    }

    public long getTxCollisions() {
        return this.txCollisions;
    }

    public long getTxCarrier() {
        return this.txCarrier;
    }

    void copyTo(NetInterfaceStat copy) {
        copy.rxBytes = this.rxBytes;
        copy.rxPackets = this.rxPackets;
        copy.rxErrors = this.rxErrors;
        copy.rxDropped = this.rxDropped;
        copy.rxOverruns = this.rxOverruns;
        copy.rxFrame = this.rxFrame;
        copy.txBytes = this.txBytes;
        copy.txPackets = this.txPackets;
        copy.txErrors = this.txErrors;
        copy.txDropped = this.txDropped;
        copy.txOverruns = this.txOverruns;
        copy.txCollisions = this.txCollisions;
        copy.txCarrier = this.txCarrier;
    }

    public Map toMap() {
        String strtxCarrier;
        String strtxCollisions;
        String strtxOverruns;
        String strtxDropped;
        String strtxErrors;
        String strtxPackets;
        String strtxBytes;
        String strrxFrame;
        String strrxOverruns;
        String strrxDropped;
        String strrxErrors;
        String strrxPackets;
        HashMap<String, String> map = new HashMap<String, String>();
        String strrxBytes = String.valueOf(this.rxBytes);
        if (!"-1".equals(strrxBytes)) {
            map.put("RxBytes", strrxBytes);
        }
        if (!"-1".equals(strrxPackets = String.valueOf(this.rxPackets))) {
            map.put("RxPackets", strrxPackets);
        }
        if (!"-1".equals(strrxErrors = String.valueOf(this.rxErrors))) {
            map.put("RxErrors", strrxErrors);
        }
        if (!"-1".equals(strrxDropped = String.valueOf(this.rxDropped))) {
            map.put("RxDropped", strrxDropped);
        }
        if (!"-1".equals(strrxOverruns = String.valueOf(this.rxOverruns))) {
            map.put("RxOverruns", strrxOverruns);
        }
        if (!"-1".equals(strrxFrame = String.valueOf(this.rxFrame))) {
            map.put("RxFrame", strrxFrame);
        }
        if (!"-1".equals(strtxBytes = String.valueOf(this.txBytes))) {
            map.put("TxBytes", strtxBytes);
        }
        if (!"-1".equals(strtxPackets = String.valueOf(this.txPackets))) {
            map.put("TxPackets", strtxPackets);
        }
        if (!"-1".equals(strtxErrors = String.valueOf(this.txErrors))) {
            map.put("TxErrors", strtxErrors);
        }
        if (!"-1".equals(strtxDropped = String.valueOf(this.txDropped))) {
            map.put("TxDropped", strtxDropped);
        }
        if (!"-1".equals(strtxOverruns = String.valueOf(this.txOverruns))) {
            map.put("TxOverruns", strtxOverruns);
        }
        if (!"-1".equals(strtxCollisions = String.valueOf(this.txCollisions))) {
            map.put("TxCollisions", strtxCollisions);
        }
        if (!"-1".equals(strtxCarrier = String.valueOf(this.txCarrier))) {
            map.put("TxCarrier", strtxCarrier);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

