/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.hyperic.sigar.SigarLoader;

public class NetServices {
    private static final String SERVICE_FILE;
    private static Map udpServices;
    private static Map tcpServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void parse(String fileName, EntryReader entry) {
        String line;
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        BufferedReader reader = null;
        ArrayList<String> aliases = new ArrayList<String>();
        reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            StringTokenizer st;
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
            aliases.clear();
            int ix = line.indexOf("#");
            if (ix != -1) {
                line = line.substring(0, ix);
            }
            if ((st = new StringTokenizer(line, " \t")).countTokens() < 2) continue;
            String name = st.nextToken().trim();
            String port = st.nextToken().trim();
            while (st.hasMoreTokens()) {
                aliases.add(st.nextToken().trim());
            }
            entry.process(name, port, aliases);
        }
        Object var11_11 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                Object var11_12 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static void parseServices(String type, Map services) {
        NetServices.parse(SERVICE_FILE, new ServicesReader(type, services));
    }

    public static String getName(String protocol, long port) {
        if (protocol.equals("tcp")) {
            return NetServices.getTcpName(port);
        }
        if (protocol.equals("udp")) {
            return NetServices.getUdpName(port);
        }
        return String.valueOf(port);
    }

    public static String getTcpName(long port) {
        if (tcpServices == null) {
            tcpServices = new HashMap();
            NetServices.parseServices("tcp", tcpServices);
        }
        return (String)tcpServices.get(new Long(port));
    }

    public static String getUdpName(long port) {
        if (udpServices == null) {
            udpServices = new HashMap();
            NetServices.parseServices("udp", udpServices);
        }
        return (String)udpServices.get(new Long(port));
    }

    static {
        udpServices = null;
        tcpServices = null;
        String defaultFile = SigarLoader.IS_WIN32 ? "C:\\windows\\system32\\drivers\\etc\\services" : "/etc/services";
        SERVICE_FILE = System.getProperty("sigar.net.services.file", defaultFile);
    }

    private static class ServicesReader
    implements EntryReader {
        private String protocol;
        private Map services;

        private ServicesReader(String protocol, Map services) {
            this.protocol = protocol;
            this.services = services;
        }

        public void process(String name, String port, List aliases) {
            int ix = port.indexOf(47);
            if (ix == -1) {
                return;
            }
            String pnum = port.substring(0, ix);
            String protocol = port.substring(ix + 1);
            if (this.protocol.equals(protocol)) {
                this.services.put(Long.valueOf(pnum), name);
            }
        }
    }

    static interface EntryReader {
        public void process(String var1, String var2, List var3);
    }
}

