/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public class ProcUtil {
    private static boolean isClassName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c == '.' || Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getJavaMainClass(SigarProxy sigar, long pid) throws SigarException {
        String[] args = sigar.getProcArgs(pid);
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (ProcUtil.isClassName(arg.trim())) {
                return arg;
            }
            if (!arg.equals("-jar")) continue;
            File file = new File(args[i + 1]);
            if (!file.isAbsolute()) {
                try {
                    String cwd = sigar.getProcExe(pid).getCwd();
                    file = new File(cwd + File.separator + file);
                }
                catch (SigarException e) {
                    // empty catch block
                }
            }
            if (!file.exists()) return file.toString();
            JarFile jar = null;
            jar = new JarFile(file);
            String string = jar.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            Object var10_10 = null;
            if (jar == null) return string;
            try {
                jar.close();
                return string;
            }
            catch (IOException e2) {
                // empty catch block
            }
            return string;
            catch (IOException e) {
                try {
                    Object var10_11 = null;
                    if (jar == null) return file.toString();
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (jar == null) throw throwable;
                    try {
                        jar.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    jar.close();
                    return file.toString();
                }
                catch (IOException e2) {}
                return file.toString();
            }
        }
        return null;
    }

    public static String getDescription(SigarProxy sigar, long pid) throws SigarException {
        String[] args;
        ProcState state = sigar.getProcState(pid);
        String name = state.getName();
        try {
            args = sigar.getProcArgs(pid);
        }
        catch (SigarException e) {
            args = new String[]{};
        }
        if (name.equals("java") || name.equals("javaw")) {
            String className = null;
            try {
                className = ProcUtil.getJavaMainClass(sigar, pid);
            }
            catch (SigarException e) {
                // empty catch block
            }
            if (className != null) {
                name = name + ":" + className;
            }
        } else if (args.length != 0) {
            name = args[0];
        } else {
            try {
                String exe = sigar.getProcExe(pid).getName();
                if (exe.length() != 0) {
                    name = exe;
                }
            }
            catch (SigarException e) {
                // empty catch block
            }
        }
        return name;
    }
}

