/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hyperic.sigar.NetServices;
import org.hyperic.sigar.Sigar;

public class RPC {
    private static Map programs = null;
    public static final int UDP = 32;
    public static final int TCP = 16;

    public static native int ping(String var0, int var1, long var2, long var4);

    public static native String strerror(int var0);

    public static int ping(String hostname, int protocol, String program, long version) {
        return RPC.ping(hostname, protocol, RPC.getProgram(program), version);
    }

    public static int ping(String hostname, long program) {
        return RPC.ping(hostname, 32, program, 2L);
    }

    public static int ping(String hostname, String program) {
        return RPC.ping(hostname, 32, program, 2L);
    }

    private static void parse(String fileName) {
        programs = new HashMap();
        NetServices.parse("/etc/rpc", new NetServices.EntryReader(){

            public void process(String program, String num, List aliases) {
                programs.put(program, num);
            }
        });
    }

    public static long getProgram(String program) {
        Long num;
        Object obj;
        if (programs == null) {
            RPC.parse("/etc/rpc");
        }
        if ((obj = programs.get(program)) == null) {
            return -1L;
        }
        if (obj instanceof Long) {
            num = (Long)obj;
        } else {
            num = Long.valueOf((String)obj);
            programs.put(program, num);
        }
        return num;
    }

    public static void main(String[] args) throws Exception {
        Sigar.load();
        int retval = RPC.ping(args[0], args[1]);
        System.out.println("(" + retval + ") " + RPC.strerror(retval));
    }
}

