/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class CpuInfo
extends SigarCommandBase {
    public boolean displayTimes = true;

    public CpuInfo(Shell shell) {
        super(shell);
    }

    public CpuInfo() {
    }

    public String getUsageShort() {
        return "Display cpu information";
    }

    private void output(CpuPerc cpu) {
        this.println("User Time....." + CpuPerc.format(cpu.getUser()));
        this.println("Sys Time......" + CpuPerc.format(cpu.getSys()));
        this.println("Idle Time....." + CpuPerc.format(cpu.getIdle()));
        this.println("Wait Time....." + CpuPerc.format(cpu.getWait()));
        this.println("Nice Time....." + CpuPerc.format(cpu.getNice()));
        this.println("Combined......" + CpuPerc.format(cpu.getCombined()));
        this.println("");
    }

    public void output(String[] args) throws SigarException {
        org.hyperic.sigar.CpuInfo[] infos = this.sigar.getCpuInfoList();
        CpuPerc[] cpus = null;
        this.println(infos.length + " total CPUs..");
        org.hyperic.sigar.CpuInfo info = infos[0];
        long cacheSize = info.getCacheSize();
        this.println("Vendor........" + info.getVendor());
        this.println("Model........." + info.getModel());
        this.println("Mhz..........." + info.getMhz());
        if (cacheSize != -1L) {
            this.println("Cache size...." + cacheSize);
        }
        this.println("");
        if (!this.displayTimes) {
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            this.println("CPU " + i + ".........");
            if (cpus == null) {
                cpus = this.sigar.getCpuPercList();
            }
            this.output(cpus[i]);
        }
        this.println("Totals........");
        this.output(this.sigar.getCpuPerc());
    }

    public static void main(String[] args) throws Exception {
        new CpuInfo().processCommand(args);
    }
}

