/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.ArrayList;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.shell.FileCompleter;
import org.hyperic.sigar.util.GetlineCompleter;

public class Iostat
extends SigarCommandBase {
    private static final String OUTPUT_FORMAT = "%-15s %-15s %10s %10s %7s %7s %5s";
    private static final String[] HEADER = new String[]{"Filesystem", "Mounted on", "Reads", "Writes", "R-bytes", "W-bytes", "Queue"};
    private GetlineCompleter completer;

    public Iostat(Shell shell) {
        super(shell);
        this.setOutputFormat(OUTPUT_FORMAT);
        this.completer = new FileCompleter(shell);
    }

    public Iostat() {
        this.setOutputFormat(OUTPUT_FORMAT);
    }

    public GetlineCompleter getCompleter() {
        return this.completer;
    }

    protected boolean validateArgs(String[] args) {
        return args.length <= 1;
    }

    public String getSyntaxArgs() {
        return "[filesystem]";
    }

    public String getUsageShort() {
        return "Report filesystem disk i/o";
    }

    public void printHeader() {
        this.printf(HEADER);
    }

    public void output(String[] args) throws SigarException {
        if (args.length == 1) {
            String name;
            FileSystemMap mounts = this.proxy.getFileSystemMap();
            FileSystem fs = mounts.getMountPoint(name = FileCompleter.expand(args[0]));
            if (fs != null) {
                this.printHeader();
                this.output(fs);
                return;
            }
            throw new SigarException(args[0] + " No such file or directory");
        }
        FileSystem[] fslist = this.proxy.getFileSystemList();
        this.printHeader();
        for (int i = 0; i < fslist.length; ++i) {
            if (fslist[i].getType() != 2) continue;
            this.output(fslist[i]);
        }
    }

    public void output(FileSystem fs) throws SigarException {
        FileSystemUsage usage = this.sigar.getFileSystemUsage(fs.getDirName());
        ArrayList<String> items = new ArrayList<String>();
        items.add(fs.getDevName());
        items.add(fs.getDirName());
        items.add(String.valueOf(usage.getDiskReads()));
        items.add(String.valueOf(usage.getDiskWrites()));
        if (usage.getDiskReadBytes() == -1L) {
            items.add("-");
            items.add("-");
        } else {
            items.add(Sigar.formatSize(usage.getDiskReadBytes()));
            items.add(Sigar.formatSize(usage.getDiskWriteBytes()));
        }
        if (usage.getDiskQueue() == -1L) {
            items.add("-");
        } else {
            items.add(String.valueOf(usage.getDiskQueue()));
        }
        this.printf(items);
    }

    public static void main(String[] args) throws Exception {
        new Iostat().processCommand(args);
    }
}

