/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetServices;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class Netstat
extends SigarCommandBase {
    private static final int LADDR_LEN = 20;
    private static final int RADDR_LEN = 35;
    private static final String[] HEADER = new String[]{"Proto", "Local Address", "Foreign Address", "State", ""};
    private static boolean isNumeric;
    private static boolean wantPid;

    public Netstat(Shell shell) {
        super(shell);
    }

    public Netstat() {
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getUsageShort() {
        return "Display network connections";
    }

    public static int getFlags(String[] args, int flags) {
        int proto_flags = 0;
        isNumeric = false;
        wantPid = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            int j = 0;
            block12: while (j < arg.length()) {
                switch (arg.charAt(j++)) {
                    case '-': {
                        continue block12;
                    }
                    case 'l': {
                        flags &= 0xFFFFFFFE;
                        flags |= 2;
                        continue block12;
                    }
                    case 'a': {
                        flags |= 3;
                        continue block12;
                    }
                    case 'n': {
                        isNumeric = true;
                        continue block12;
                    }
                    case 'p': {
                        wantPid = true;
                        continue block12;
                    }
                    case 't': {
                        proto_flags |= 0x10;
                        continue block12;
                    }
                    case 'u': {
                        proto_flags |= 0x20;
                        continue block12;
                    }
                    case 'w': {
                        proto_flags |= 0x40;
                        continue block12;
                    }
                    case 'x': {
                        proto_flags |= 0x80;
                        continue block12;
                    }
                }
                System.err.println("unknown option");
            }
        }
        if (proto_flags != 0) {
            flags &= 0xFFFFFF0F;
            flags |= proto_flags;
        }
        return flags;
    }

    private String formatPort(String proto, long port) {
        String service;
        if (port == 0L) {
            return "*";
        }
        if (!isNumeric && (service = NetServices.getName(proto, port)) != null) {
            return service;
        }
        return String.valueOf(port);
    }

    private String formatAddress(String proto, String ip, long portnum, int max) {
        String address;
        String port = this.formatPort(proto, portnum);
        if (NetFlags.isAnyAddress(ip)) {
            address = "*";
        } else if (isNumeric) {
            address = ip;
        } else {
            try {
                address = InetAddress.getByName(ip).getHostName();
            }
            catch (UnknownHostException e) {
                address = ip;
            }
        }
        if (address.length() > (max -= port.length() + 1)) {
            address = address.substring(0, max);
        }
        return address + ":" + port;
    }

    public void output(String[] args) throws SigarException {
        int flags = 241;
        if (args.length > 0) {
            flags = Netstat.getFlags(args, flags);
        }
        NetConnection[] connections = this.sigar.getNetConnectionList(flags);
        this.printf(HEADER);
        for (int i = 0; i < connections.length; ++i) {
            NetConnection conn = connections[i];
            String proto = conn.getTypeString();
            String state = conn.getType() == 32 ? "" : conn.getStateString();
            ArrayList<String> items = new ArrayList<String>();
            items.add(proto);
            items.add(this.formatAddress(proto, conn.getLocalAddress(), conn.getLocalPort(), 20));
            items.add(this.formatAddress(proto, conn.getRemoteAddress(), conn.getRemotePort(), 35));
            items.add(state);
            String process = null;
            if (wantPid && conn.getState() == 10) {
                try {
                    long pid = this.sigar.getProcPort(conn.getType(), conn.getLocalPort());
                    if (pid != 0L) {
                        String name = this.sigar.getProcState(pid).getName();
                        process = pid + "/" + name;
                    }
                }
                catch (SigarException e) {
                    // empty catch block
                }
            }
            if (process == null) {
                process = "";
            }
            items.add(process);
            this.printf(items);
        }
    }

    public static void main(String[] args) throws Exception {
        new Netstat().processCommand(args);
    }
}

