/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.ProcessQueryGenerate;
import org.hyperic.sigar.cmd.Ps;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.ptql.ProcessQueryBuilder;
import org.hyperic.sigar.shell.CollectionCompleter;
import org.hyperic.sigar.shell.MultiwordShellCommand;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandInitException;
import org.hyperic.sigar.shell.ShellCommandUsageException;
import org.hyperic.sigar.util.GetlineCompleter;

public class PTQL
extends MultiwordShellCommand
implements GetlineCompleter {
    private Shell shell;
    private Ps ps;
    private GetlineCompleter m_completer;
    private Map methods;

    private PTQL() {
    }

    public PTQL(Shell shell) {
        this.shell = shell;
        this.ps = new Ps(this.shell);
        this.methods = ProcessQueryBuilder.getMethods();
        this.m_completer = new CollectionCompleter(shell, this.methods.keySet());
    }

    public String complete(String line) {
        int ix = line.indexOf(".");
        if (ix == -1) {
            if (!(line = this.m_completer.complete(line)).endsWith(".") && this.methods.get(line) != null) {
                return line + ".";
            }
            return line;
        }
        String attrClass = line.substring(0, ix);
        String attr = line.substring(ix + 1, line.length());
        Method method = (Method)this.methods.get(attrClass);
        if (method == null) {
            return line;
        }
        Class<?> subtype = method.getReturnType();
        boolean isSigarClass = ProcessQueryBuilder.isSigarClass(subtype);
        int ix2 = attr.indexOf(".");
        if (ix2 != -1) {
            method = null;
            String op = attr.substring(ix2 + 1, attr.length());
            attr = attr.substring(0, ix2);
            if (isSigarClass) {
                try {
                    method = subtype.getMethod("get" + attr, ProcessQueryBuilder.NOPARAM);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            Method m = method;
            CollectionCompleter completer = new CollectionCompleter(this.shell, ProcessQueryBuilder.getMethodOpNames(m));
            String partial = completer.complete(op);
            String result = attrClass + "." + attr + "." + partial;
            if (partial.length() == 2) {
                result = result + "=";
            }
            return result;
        }
        if (isSigarClass) {
            ArrayList<String> possible = new ArrayList<String>();
            Method[] submethods = subtype.getDeclaredMethods();
            for (int i = 0; i < submethods.length; ++i) {
                Method m = submethods[i];
                if (!m.getName().startsWith("get")) continue;
                possible.add(m.getName().substring(3));
            }
            CollectionCompleter completer = new CollectionCompleter(this.shell, possible);
            String partial = completer.complete(attr);
            String result = attrClass + "." + partial;
            if (possible.contains(partial)) {
                result = result + ".";
            }
            return result;
        }
        return line;
    }

    public void init(String commandName, ShellBase shell) throws ShellCommandInitException {
        super.init(commandName, shell);
        ProcessQueryGenerate handler = new ProcessQueryGenerate(this.shell);
        this.registerSubHandler("generate", handler);
    }

    public String getSyntaxArgs() {
        return "<query>";
    }

    public String getUsageShort() {
        return "Run process table query";
    }

    public void processCommand(String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        long[] pids;
        if (args.length > 0 && this.getSubHandler(args[0]) != null) {
            super.processCommand(args);
            return;
        }
        if (args.length != 1) {
            throw new ShellCommandUsageException(this.getSyntax());
        }
        try {
            pids = this.shell.findPids(args);
        }
        catch (NumberFormatException e) {
            throw new ShellCommandUsageException(this.getSyntax());
        }
        catch (SigarException e) {
            throw new ShellCommandExecException(e.getMessage());
        }
        for (int i = 0; i < pids.length; ++i) {
            try {
                this.ps.output(pids[i]);
                continue;
            }
            catch (SigarException e) {
                throw new ShellCommandExecException(e.getMessage());
            }
        }
        this.ps.flush();
    }
}

