/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.List;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.CurrentProcessSummary;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.cmd.Ps;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.Uptime;

public class Top {
    private static final int SLEEP_TIME = 5000;
    private static final String HEADER = "PID\tUSER\tSTIME\tSIZE\tRSS\tSHARE\tSTATE\tTIME\t%CPU\tCOMMAND";

    public static void main(String[] args) throws Exception {
        Sigar sigarImpl = new Sigar();
        SigarProxy sigar = SigarProxyCache.newInstance(sigarImpl, 5000);
        while (true) {
            Shell.clearScreen();
            System.out.println(Uptime.getInfo(sigar));
            System.out.println(CurrentProcessSummary.get(sigar));
            System.out.println(sigar.getCpuPerc());
            System.out.println(sigar.getMem());
            System.out.println(sigar.getSwap());
            System.out.println();
            System.out.println(HEADER);
            long[] pids = Shell.getPids(sigar, args);
            for (int i = 0; i < pids.length; ++i) {
                long pid = pids[i];
                String cpuPerc = "?";
                List info = Ps.getInfo(sigar, pid);
                try {
                    ProcCpu cpu = sigar.getProcCpu(pid);
                    cpuPerc = CpuPerc.format(cpu.getPercent());
                }
                catch (SigarException e) {
                    // empty catch block
                }
                info.add(info.size() - 1, cpuPerc);
                System.out.println(Ps.join(info));
            }
            Thread.sleep(5000L);
            SigarProxyCache.clear(sigar);
        }
    }
}

