/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.ptql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.PidQuery;

public class PidFileQuery
extends PidQuery {
    File file;
    long modified = -1L;

    public PidFileQuery(String file) {
        this.file = new File(file);
    }

    public long getPid() throws SigarException {
        char c;
        String line;
        if (!this.file.exists()) {
            throw new SigarException(this.file + " does not exist");
        }
        long lastMod = this.file.lastModified();
        if (lastMod == this.modified) {
            return this.pid;
        }
        this.modified = lastMod;
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.file));
            while ((line = in.readLine()) != null && (line = line.trim()).length() == 0) {
            }
        }
        catch (FileNotFoundException e) {
            throw new SigarException(e.getMessage());
        }
        catch (IOException e) {
            throw new SigarException(e.getMessage());
        }
        int len = line.length();
        StringBuffer number = new StringBuffer(len);
        char[] chars = line.toCharArray();
        for (int i = 0; i < len && Character.isDigit(c = chars[i]); ++i) {
            number.append(c);
        }
        try {
            this.pid = Long.parseLong(number.toString());
        }
        catch (NumberFormatException e) {
            throw new SigarException("Not a number: " + line);
        }
        return this.pid;
    }
}

