/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.ptql;

import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.ptql.MalformedQueryException;
import org.hyperic.sigar.ptql.PidQuery;
import org.hyperic.sigar.ptql.ProcessQuery;
import org.hyperic.sigar.ptql.ProcessQueryFactory;
import org.hyperic.sigar.ptql.QueryLoadException;

public class ProcessFinder {
    private SigarProxy proxy;
    private static final long[] NO_MATCHES = new long[0];
    private static final long[] ONE_MATCH = new long[1];

    public ProcessFinder(SigarProxy proxy) {
        this.proxy = proxy;
        this.proxy.getPid();
    }

    public long findSingleProcess(String query) throws SigarException, SigarNotImplementedException {
        try {
            ProcessQuery processQuery = ProcessQueryFactory.getInstance(query);
            return this.findSingleProcess(processQuery);
        }
        catch (MalformedQueryException e) {
            throw new SigarException(e.getMessage());
        }
        catch (QueryLoadException e) {
            throw new SigarException(e.getMessage());
        }
    }

    public long findSingleProcess(ProcessQuery query) throws SigarException, SigarNotImplementedException, MalformedQueryException {
        if (query instanceof PidQuery) {
            return ((PidQuery)query).getPid();
        }
        int matches = 0;
        long[] pids = this.proxy.getProcList();
        long pid = -1L;
        for (int i = 0; i < pids.length; ++i) {
            try {
                if (!query.match(this.proxy, pids[i])) continue;
                ++matches;
                pid = pids[i];
                continue;
            }
            catch (SigarNotImplementedException e) {
                throw e;
            }
            catch (SigarException e) {
                // empty catch block
            }
        }
        if (matches == 1) {
            return pid;
        }
        String msg = matches == 0 ? "Query did not match any processes" : "Query matched multiple processes (" + matches + ")";
        throw new MalformedQueryException(msg);
    }

    public static long[] find(Sigar sigar, String query) throws SigarException {
        SigarProxy proxy = SigarProxyCache.newInstance(sigar);
        return ProcessFinder.find(proxy, query);
    }

    public static long[] find(SigarProxy sigar, String query) throws SigarException {
        ProcessFinder finder = new ProcessFinder(sigar);
        try {
            return finder.find(ProcessQueryFactory.getInstance(query));
        }
        catch (QueryLoadException e) {
            throw new SigarException(e.getMessage());
        }
        catch (MalformedQueryException e) {
            throw new SigarException(e.getMessage());
        }
    }

    public long[] find(StringBuffer query) throws SigarException, SigarNotImplementedException {
        return this.find(query.toString());
    }

    public long[] find(String query) throws SigarException, SigarNotImplementedException {
        try {
            return this.find(ProcessQueryFactory.getInstance(query));
        }
        catch (QueryLoadException e) {
            throw new SigarException(e.getMessage());
        }
        catch (MalformedQueryException e) {
            throw new SigarException(e.getMessage());
        }
    }

    public long[] find(ProcessQuery query) throws SigarException, SigarNotImplementedException {
        int matches = 0;
        int lastMatch = -1;
        long[] pids = (long[])this.proxy.getProcList().clone();
        for (int i = 0; i < pids.length; ++i) {
            long pid = pids[i];
            boolean add = false;
            try {
                add = query.match(this.proxy, pid);
            }
            catch (SigarNotImplementedException e) {
                throw e;
            }
            catch (SigarException e) {
                // empty catch block
            }
            if (add) {
                ++matches;
                lastMatch = i;
                continue;
            }
            pids[i] = -1L;
        }
        if (matches == 1) {
            ProcessFinder.ONE_MATCH[0] = pids[lastMatch];
            return ONE_MATCH;
        }
        if (matches == 0) {
            return NO_MATCHES;
        }
        long[] matched = new long[matches];
        int j = 0;
        for (int i = 0; i <= lastMatch; ++i) {
            if (pids[i] == -1L) continue;
            matched[j++] = pids[i];
        }
        return matched;
    }
}

