/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.ptql;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.MalformedQueryException;
import org.hyperic.sigar.ptql.ProcessQuery;
import org.hyperic.sigar.ptql.ProcessQueryClassLoader;
import org.hyperic.sigar.ptql.QueryBranch;
import org.hyperic.sigar.ptql.QueryLoadException;
import org.hyperic.sigar.ptql.StringOp;

public class ProcessQueryBuilder {
    private static final boolean dumpClasses;
    private static int generation;
    private static final String SIGAR_PACKAGE = "org.hyperic.sigar.";
    private static final String PROC_PREFIX = "org.hyperic.sigar.Proc";
    private static final String PROXY_CLASS = "org.hyperic.sigar.SigarProxy";
    private static final String PROXY_HELPER = "org.hyperic.sigar.ptql.ProcessQueryHelper";
    private static final String GENERATION_PACKAGE = "org.hyperic.sigar.ptql.GENERATED.";
    private static final String[] GENERATION_IMPL;
    public static final Class[] NOPARAM;
    static final char MOD_CLONE = 'C';
    static final char MOD_PARENT = 'P';
    static final char MOD_VALUE = 'V';
    private static final HashMap INUMOPS;
    private static final HashMap LNUMOPS;
    private static final HashMap STROPS;
    private static final HashMap IFMETHODS;
    private InstructionFactory factory;
    private ConstantPoolGen pool;
    private ClassGen generator;
    private String className;
    private MethodGen query;
    private InstructionList qi = new InstructionList();
    private ArrayList branches = new ArrayList();
    static final boolean COMPAT_1_4;
    static /* synthetic */ Class class$org$hyperic$sigar$ptql$ProcessQuery;
    static /* synthetic */ Class class$org$hyperic$sigar$SigarProxy;
    static /* synthetic */ Class class$java$lang$String;

    public ProcessQueryBuilder() {
        this.init();
    }

    public static Map getMethods() {
        return IFMETHODS;
    }

    public static Set getMethodOpNames(Method method) {
        if (method == null) {
            return STROPS.keySet();
        }
        Class<?> rtype = method.getReturnType();
        if (rtype == Character.TYPE || rtype == Double.TYPE || rtype == Integer.TYPE || rtype == Long.TYPE) {
            return LNUMOPS.keySet();
        }
        return STROPS.keySet();
    }

    public static boolean isSigarClass(Class type) {
        return type.getName().startsWith(SIGAR_PACKAGE);
    }

    private void init() {
        String name = ProcessQueryBuilder.genClassName();
        this.className = GENERATION_PACKAGE + name;
        this.generator = new ClassGen(this.className, "java.lang.Object", this.className + ".java", 33, GENERATION_IMPL);
        this.pool = this.generator.getConstantPool();
        this.factory = new InstructionFactory(this.generator, this.pool);
        this.createConstructor();
        this.query = new MethodGen(1, (Type)Type.BOOLEAN, new Type[]{new ObjectType(PROXY_CLASS), Type.LONG}, new String[]{"sigar", "pid"}, "match", this.getClassName(), this.qi, this.pool);
    }

    private void loadSigarArg() {
        this.qi.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)1));
    }

    private void loadPidArg() {
        this.qi.append((Instruction)InstructionFactory.createLoad((Type)Type.LONG, (int)2));
    }

    private static synchronized String genClassName() {
        return "PTQL" + generation++;
    }

    public String getClassName() {
        return this.className;
    }

    private void createConstructor() {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<init>", this.getClassName(), il, this.pool);
        il.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
        il.append((Instruction)this.factory.createInvoke("java.lang.Object", "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        this.generator.addMethod(method.getMethod());
        il.dispose();
    }

    private void loadStandardArgs(QueryOp qop) {
        if (qop.isParent) {
            this.loadSigarArg();
        }
        this.loadSigarArg();
        this.loadPidArg();
        if (!qop.isParent) {
            return;
        }
        String procState = "org.hyperic.sigar.ProcState";
        this.qi.append((Instruction)this.factory.createInvoke(PROXY_CLASS, "getProcState", (Type)new ObjectType("org.hyperic.sigar.ProcState"), new Type[]{Type.LONG}, (short)185));
        this.qi.append((Instruction)this.factory.createInvoke("org.hyperic.sigar.ProcState", "getPpid", (Type)Type.LONG, Type.NO_ARGS, (short)182));
    }

    private void createStandardInvoker(String attrClass, String attr, Type type) {
        this.qi.append((Instruction)this.factory.createInvoke(PROXY_CLASS, "getProc" + attrClass, (Type)new ObjectType(PROC_PREFIX + attrClass), new Type[]{Type.LONG}, (short)185));
        this.qi.append((Instruction)this.factory.createInvoke(PROC_PREFIX + attrClass, "get" + attr, type, Type.NO_ARGS, (short)182));
    }

    private MalformedQueryException unsupportedOp(String name) {
        return new MalformedQueryException("Unsupported operator: " + name);
    }

    private MalformedQueryException unsupportedMethod(String name) {
        return new MalformedQueryException("Unsupported method: " + name);
    }

    private MalformedQueryException unsupportedAttribute(String name) {
        return new MalformedQueryException("Unsupported attribute: " + name);
    }

    private StringOp getStringOp(String op) throws QueryLoadException, MalformedQueryException {
        StringOp sop = (StringOp)STROPS.get(op);
        if (sop == null) {
            throw this.unsupportedOp(op);
        }
        if (!COMPAT_1_4 && op.equals("re")) {
            throw new QueryLoadException(op + " requires jdk 1.4+");
        }
        return sop;
    }

    private void createStringInvoker(String op) throws QueryLoadException, MalformedQueryException {
        StringOp sop = this.getStringOp(op);
        this.qi.append((Instruction)this.factory.createInvoke("java.lang.String", sop.name, sop.returnType, new Type[]{sop.type}, (short)182));
        if (op.equals("ct")) {
            this.qi.append((CompoundInstruction)new PUSH(this.pool, -1));
        }
        BranchInstruction branch = InstructionFactory.createBranchInstruction((short)sop.opcode, null);
        this.qi.append(branch);
        this.branches.add(branch);
    }

    public void appendProcPortOp(String flags, String op, int protocol, long val) throws MalformedQueryException {
        QueryOp qop = new QueryOp(op);
        this.loadSigarArg();
        this.qi.append((CompoundInstruction)new PUSH(this.pool, protocol));
        this.qi.append((CompoundInstruction)new PUSH(this.pool, val));
        this.qi.append((Instruction)this.factory.createInvoke(PROXY_CLASS, "getProcPort", (Type)Type.LONG, new Type[]{Type.INT, Type.LONG}, (short)185));
        this.loadPidArg();
        this.qi.append(InstructionConstants.LCMP);
        Short sop = (Short)LNUMOPS.get(qop.op);
        if (sop == null) {
            throw this.unsupportedOp(qop.op);
        }
        BranchInstruction branch = InstructionFactory.createBranchInstruction((short)sop, null);
        this.qi.append(branch);
        this.branches.add(branch);
    }

    public void appendEnvOp(String key, String op, String val) throws QueryLoadException, MalformedQueryException {
        QueryOp qop = new QueryOp(op);
        this.loadStandardArgs(qop);
        this.qi.append((CompoundInstruction)new PUSH(this.pool, key));
        this.qi.append((Instruction)this.factory.createInvoke(PROXY_HELPER, "getProcEnv", (Type)Type.STRING, new Type[]{new ObjectType(PROXY_CLASS), Type.LONG, Type.STRING}, (short)184));
        this.qi.append((CompoundInstruction)new PUSH(this.pool, val));
        this.createStringInvoker(qop.op);
    }

    public void appendArgsOp(int idx, String op, String val) throws QueryLoadException, MalformedQueryException {
        QueryOp qop = new QueryOp(op);
        this.loadStandardArgs(qop);
        this.qi.append((CompoundInstruction)new PUSH(this.pool, idx));
        this.qi.append((Instruction)this.factory.createInvoke(PROXY_HELPER, "getProcArg", (Type)Type.STRING, new Type[]{new ObjectType(PROXY_CLASS), Type.LONG, Type.INT}, (short)184));
        this.qi.append((CompoundInstruction)new PUSH(this.pool, val));
        this.createStringInvoker(qop.op);
    }

    public void appendArgsMatch(String op, String val) throws QueryLoadException, MalformedQueryException {
        QueryOp qop = new QueryOp(op);
        this.getStringOp(qop.op);
        this.loadStandardArgs(qop);
        this.qi.append((CompoundInstruction)new PUSH(this.pool, val));
        this.qi.append((CompoundInstruction)new PUSH(this.pool, qop.op));
        this.qi.append((Instruction)this.factory.createInvoke(PROXY_HELPER, "argsMatch", (Type)Type.BOOLEAN, new Type[]{new ObjectType(PROXY_CLASS), Type.LONG, Type.STRING, Type.STRING}, (short)184));
        BranchInstruction branch = InstructionFactory.createBranchInstruction((short)153, null);
        this.qi.append(branch);
        this.branches.add(branch);
    }

    public void appendStringOp(String attrClass, String attr, String op, String val) throws QueryLoadException, MalformedQueryException {
        QueryOp qop = new QueryOp(op);
        this.loadStandardArgs(qop);
        this.createStandardInvoker(attrClass, attr, (Type)Type.STRING);
        if (qop.isValue) {
            return;
        }
        if (qop.isClone) {
            this.append(val, null);
        } else {
            this.qi.append((CompoundInstruction)new PUSH(this.pool, val));
        }
        this.createStringInvoker(qop.op);
    }

    public void appendNumberOp(String attrClass, String attr, String op, int val) throws MalformedQueryException {
        this.appendNumberOp(attrClass, attr, op, (Type)Type.INT, 0L, 0.0, val);
    }

    public void appendNumberOp(String attrClass, String attr, String op, long val) throws MalformedQueryException {
        this.appendNumberOp(attrClass, attr, op, (Type)Type.LONG, val, 0.0, 0);
    }

    public void appendNumberOp(String attrClass, String attr, String op, double val) throws MalformedQueryException {
        this.appendNumberOp(attrClass, attr, op, (Type)Type.DOUBLE, 0L, val, 0);
    }

    private void appendNumberOp(String attrClass, String attr, String op, Type type, long val, double dval, int ival) throws MalformedQueryException {
        HashMap nops;
        if (type == Type.INT || type == Type.CHAR) {
            nops = INUMOPS;
            this.qi.append((CompoundInstruction)new PUSH(this.pool, ival));
        } else if (type == Type.DOUBLE) {
            nops = LNUMOPS;
            this.qi.append((CompoundInstruction)new PUSH(this.pool, dval));
        } else {
            nops = LNUMOPS;
            this.qi.append((CompoundInstruction)new PUSH(this.pool, val));
        }
        QueryOp qop = new QueryOp(op);
        this.loadStandardArgs(qop);
        this.createStandardInvoker(attrClass, attr, type);
        Short sop = (Short)nops.get(qop.op);
        if (sop == null) {
            throw this.unsupportedOp(qop.op);
        }
        if (type == Type.LONG) {
            this.qi.append(InstructionConstants.LCMP);
        } else if (type == Type.DOUBLE) {
            this.qi.append(InstructionConstants.DCMPL);
        }
        BranchInstruction branch = InstructionFactory.createBranchInstruction((short)sop, null);
        this.qi.append(branch);
        this.branches.add(branch);
    }

    private void appendPidOp(String op, String val) throws MalformedQueryException {
        HashMap nops = LNUMOPS;
        if (val.equals("$$")) {
            this.loadSigarArg();
            this.qi.append((Instruction)this.factory.createInvoke(PROXY_CLASS, "getPid", (Type)Type.LONG, Type.NO_ARGS, (short)185));
        } else {
            long longVal;
            try {
                longVal = Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                String msg = "Pid value '" + val + "' is not a number";
                throw new MalformedQueryException(msg);
            }
            this.qi.append((CompoundInstruction)new PUSH(this.pool, longVal));
        }
        this.loadPidArg();
        QueryOp qop = new QueryOp(op);
        Short sop = (Short)nops.get(qop.op);
        if (sop == null) {
            throw this.unsupportedOp(qop.op);
        }
        this.qi.append(InstructionConstants.LCMP);
        BranchInstruction branch = InstructionFactory.createBranchInstruction((short)sop, null);
        this.qi.append(branch);
        this.branches.add(branch);
    }

    public void append(String branch, String val) throws QueryLoadException, MalformedQueryException {
        QueryBranch qb = new QueryBranch(branch);
        String attrClass = qb.attrClass;
        String attr = qb.attr;
        String op = qb.op;
        if (attrClass.equals("Env")) {
            this.appendEnvOp(attr, op, val);
        } else if (attrClass.equals("Args")) {
            if (attr.equals("*")) {
                this.appendArgsMatch(op, val);
            } else {
                int idx;
                try {
                    idx = Integer.parseInt(attr);
                }
                catch (NumberFormatException e) {
                    String msg = "Array index '" + attr + "' is not a number";
                    throw new MalformedQueryException(msg);
                }
                this.appendArgsOp(idx, op, val);
            }
        } else if (attrClass.equals("Port")) {
            int protocol;
            long port;
            try {
                port = Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                String msg = "Port value '" + val + "' is not a number";
                throw new MalformedQueryException(msg);
            }
            try {
                protocol = NetFlags.getConnectionProtocol(attr);
            }
            catch (SigarException e) {
                throw new MalformedQueryException(e.getMessage());
            }
            this.appendProcPortOp(attr, op, protocol, port);
        } else if (attrClass.equals("Pid")) {
            this.appendPidOp(op, val);
        } else {
            Method method = (Method)IFMETHODS.get(attrClass);
            if (method == null) {
                throw this.unsupportedMethod(attrClass);
            }
            Class<?> subtype = method.getReturnType();
            boolean isStringType = false;
            if (ProcessQueryBuilder.isSigarClass(subtype)) {
                try {
                    method = subtype.getMethod("get" + attr, NOPARAM);
                }
                catch (NoSuchMethodException e) {
                    throw this.unsupportedAttribute(attr);
                }
                if (method.getReturnType() == (class$java$lang$String == null ? (class$java$lang$String = ProcessQueryBuilder.class$("java.lang.String")) : class$java$lang$String)) {
                    isStringType = true;
                } else {
                    if (method.getReturnType() == Character.TYPE) {
                        if (val.length() != 1) {
                            String msg = val + " is not a char";
                            throw new MalformedQueryException(msg);
                        }
                        char c = val.charAt(0);
                        this.appendNumberOp(attrClass, attr, op, (Type)Type.CHAR, 0L, 0.0, c);
                        return;
                    }
                    if (method.getReturnType() == Double.TYPE) {
                        try {
                            double doubleVal = Double.parseDouble(val);
                            this.appendNumberOp(attrClass, attr, op, doubleVal);
                            return;
                        }
                        catch (NumberFormatException e) {
                            String msg = val + " is not a double";
                            throw new MalformedQueryException(msg);
                        }
                    }
                }
            } else {
                isStringType = true;
            }
            if (!isStringType && Character.isDigit(val.charAt(0))) {
                try {
                    long longVal = Long.parseLong(val);
                    this.appendNumberOp(attrClass, attr, op, longVal);
                    return;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.appendStringOp(attrClass, attr, op, val);
        }
    }

    String addModifier(String key, char modifier) throws MalformedQueryException {
        int ix = key.lastIndexOf(".");
        if (ix < 0) {
            throw new MalformedQueryException();
        }
        return key.substring(0, ix + 1) + modifier + key.substring(ix + 1, key.length());
    }

    public void finish() {
        this.qi.append((CompoundInstruction)new PUSH(this.pool, 1));
        BranchInstruction gotoBranch = InstructionFactory.createBranchInstruction((short)167, null);
        this.qi.append(gotoBranch);
        InstructionHandle target = this.qi.append((CompoundInstruction)new PUSH(this.pool, 0));
        InstructionHandle retval = this.qi.append((Instruction)InstructionFactory.createReturn((Type)Type.INT));
        for (int i = 0; i < this.branches.size(); ++i) {
            BranchInstruction branch = (BranchInstruction)this.branches.get(i);
            branch.setTarget(target);
        }
        gotoBranch.setTarget(retval);
        this.query.setMaxStack();
        this.query.setMaxLocals();
        this.generator.addMethod(this.query.getMethod());
        this.qi.dispose();
    }

    public ProcessQuery load() throws QueryLoadException {
        Class<?> genclass;
        if (dumpClasses) {
            try {
                FileOutputStream os = new FileOutputStream(this.getClassName() + ".class");
                this.dump(os);
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] bytecode = this.generator.getJavaClass().getBytes();
        ClassLoader parent = this.getClass().getClassLoader();
        ProcessQueryClassLoader cl = new ProcessQueryClassLoader(parent, bytecode);
        try {
            genclass = cl.loadClass(this.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new QueryLoadException("ClassNotFoundException: " + e.getMessage());
        }
        try {
            return (ProcessQuery)genclass.newInstance();
        }
        catch (InstantiationException e) {
            throw new QueryLoadException("InstantiationException: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new QueryLoadException("IllegalAccessException: " + e.getMessage());
        }
    }

    public void dump(OutputStream os) throws IOException {
        this.generator.getJavaClass().dump(os);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        boolean isCompat;
        dumpClasses = "true".equals(System.getProperty("sigar.ptql.dumpClasses"));
        generation = 0;
        GENERATION_IMPL = new String[]{(class$org$hyperic$sigar$ptql$ProcessQuery == null ? (class$org$hyperic$sigar$ptql$ProcessQuery = ProcessQueryBuilder.class$("org.hyperic.sigar.ptql.ProcessQuery")) : class$org$hyperic$sigar$ptql$ProcessQuery).getName()};
        NOPARAM = new Class[0];
        HashMap<String, Short> lnops = new HashMap<String, Short>();
        lnops.put("eq", new Short(154));
        lnops.put("ne", new Short(153));
        lnops.put("gt", new Short(156));
        lnops.put("ge", new Short(157));
        lnops.put("lt", new Short(158));
        lnops.put("le", new Short(155));
        LNUMOPS = lnops;
        HashMap<String, Short> inops = new HashMap<String, Short>();
        inops.put("eq", new Short(160));
        inops.put("ne", new Short(159));
        inops.put("gt", new Short(162));
        inops.put("ge", new Short(163));
        inops.put("lt", new Short(164));
        inops.put("le", new Short(161));
        INUMOPS = inops;
        HashMap<String, StringOp> sops = new HashMap<String, StringOp>();
        sops.put("ew", new StringOp("endsWith", 153));
        sops.put("sw", new StringOp("startsWith", 153));
        sops.put("eq", new StringOp("equals", 153));
        sops.put("ne", new StringOp("equals", 154));
        sops.put("re", new StringOp("matches", 153));
        sops.put("ct", new StringOp("indexOf", 159));
        STROPS = sops;
        HashMap<String, Method> iftab = new HashMap<String, Method>();
        Method[] methods = (class$org$hyperic$sigar$SigarProxy == null ? (class$org$hyperic$sigar$SigarProxy = ProcessQueryBuilder.class$(PROXY_CLASS)) : class$org$hyperic$sigar$SigarProxy).getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            String name = methods[i].getName();
            if (!name.startsWith("getProc") || (params = methods[i].getParameterTypes()).length != 1 || params[0] != Long.TYPE) continue;
            iftab.put(name.substring(7), methods[i]);
        }
        IFMETHODS = iftab;
        try {
            Class.forName("java.net.SocketAddress");
            isCompat = true;
        }
        catch (ClassNotFoundException e) {
            isCompat = false;
        }
        COMPAT_1_4 = isCompat;
    }

    class QueryOp {
        String op;
        int flags;
        boolean isParent = false;
        boolean isClone = false;
        boolean isValue = false;

        public QueryOp(String val) throws MalformedQueryException {
            char c;
            int i = 0;
            while (Character.isUpperCase(c = val.charAt(i))) {
                switch (c) {
                    case 'C': {
                        this.isClone = true;
                        break;
                    }
                    case 'P': {
                        this.isParent = true;
                        break;
                    }
                    case 'V': {
                        this.isValue = true;
                        break;
                    }
                    default: {
                        String msg = "Unsupported modifier: " + c;
                        throw new MalformedQueryException(msg);
                    }
                }
                ++i;
            }
            this.op = val.substring(i);
        }
    }
}

