/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.ptql;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.MalformedQueryException;
import org.hyperic.sigar.ptql.PidFileQuery;
import org.hyperic.sigar.ptql.ProcessQuery;
import org.hyperic.sigar.ptql.ProcessQueryBuilder;
import org.hyperic.sigar.ptql.QueryBranch;
import org.hyperic.sigar.ptql.QueryBranchMap;
import org.hyperic.sigar.ptql.QueryLoadException;
import org.hyperic.sigar.ptql.SigarProcessQuery;
import org.hyperic.sigar.ptql.WindowsServiceQuery;
import org.hyperic.sigar.util.ReferenceMap;

public class ProcessQueryFactory
implements Comparator {
    private static final boolean useNative = "true".equals(System.getProperty("sigar.ptql.native"));
    private static Map cache = ReferenceMap.synchronizedMap();

    private int getOrder(String s) {
        if (s.startsWith("Port.")) {
            return 11;
        }
        if (s.startsWith("Env.")) {
            return 10;
        }
        if (s.startsWith("Args.")) {
            return 9;
        }
        if (s.startsWith("Exe.")) {
            return 8;
        }
        if (s.startsWith("State.")) {
            return 7;
        }
        return 1;
    }

    public int compare(Object o1, Object o2) {
        return this.getOrder((String)o1) - this.getOrder((String)o2);
    }

    public ProcessQuery prepare(QueryBranchMap map) throws MalformedQueryException, QueryLoadException {
        ProcessQueryBuilder builder = new ProcessQueryBuilder();
        String[] keys = map.keySet().toArray(new String[0]);
        Arrays.sort(keys, this);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String val = (String)map.get(key);
            if (val.charAt(0) == '$') {
                String var = val.substring(1);
                try {
                    int ix = Integer.parseInt(var);
                    if (--ix < 0 || ix >= map.branches.size()) {
                        String msg = "Variable out of range " + var;
                        throw new MalformedQueryException(msg);
                    }
                    var = (String)map.branches.get(ix);
                    var = builder.addModifier(var, 'V');
                    key = builder.addModifier(key, 'C');
                }
                catch (NumberFormatException e) {
                    var = System.getProperty(var, val);
                }
                val = var;
            }
            builder.append(key, val);
        }
        builder.finish();
        return builder.load();
    }

    private static ProcessQuery getPidInstance(String query) throws MalformedQueryException {
        if (query.indexOf(",") > 0) {
            throw new MalformedQueryException("Invalid Pid query");
        }
        String[] vals = QueryBranch.split(query);
        QueryBranch branch = new QueryBranch(vals[0]);
        String val = vals[1];
        if (!branch.op.equals("eq")) {
            throw new MalformedQueryException("Invalid Pid operator");
        }
        if (branch.attr.equals("PidFile")) {
            return new PidFileQuery(val);
        }
        if (branch.attr.equals("Service")) {
            return new WindowsServiceQuery(val);
        }
        throw new MalformedQueryException("Unsupported method: " + branch.attr);
    }

    public static ProcessQuery getInstance(String query) throws MalformedQueryException, QueryLoadException {
        if (query == null) {
            throw new MalformedQueryException("null query");
        }
        if (query.length() == 0) {
            throw new MalformedQueryException("empty query");
        }
        ProcessQuery pQuery = (ProcessQuery)cache.get(query);
        if (pQuery != null) {
            return pQuery;
        }
        if (useNative) {
            pQuery = new SigarProcessQuery();
            try {
                ((SigarProcessQuery)pQuery).create(query);
            }
            catch (SigarException e) {
                throw new MalformedQueryException(e.getMessage());
            }
            cache.put(query, pQuery);
            return pQuery;
        }
        if (query.startsWith("Pid.PidFile.") || query.startsWith("Pid.Service.")) {
            pQuery = ProcessQueryFactory.getPidInstance(query);
            cache.put(query, pQuery);
            return pQuery;
        }
        QueryBranchMap queries = new QueryBranchMap();
        StringTokenizer st = new StringTokenizer(query, ",");
        while (st.hasMoreTokens()) {
            String[] vals = QueryBranch.split(st.nextToken());
            queries.put(vals[0], vals[1]);
        }
        ProcessQueryFactory factory = new ProcessQueryFactory();
        pQuery = factory.prepare(queries);
        cache.put(query, pQuery);
        return pQuery;
    }
}

