/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.ptql;

import org.hyperic.sigar.ProcCred;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.ptql.ProcessFinder;

public class ProcessQueryGenerator {
    private ProcessFinder finder;
    private SigarProxy sigar;

    public ProcessQueryGenerator(SigarProxy sigar) {
        this.sigar = sigar;
        this.finder = new ProcessFinder(sigar);
    }

    public String generate(long pid) throws SigarException {
        StringBuffer query = new StringBuffer();
        ProcState state = this.sigar.getProcState(pid);
        query.append("State.Name.eq=" + state.getName());
        if (this.finder.find(query).length == 1) {
            return query.toString();
        }
        try {
            ProcCred cred = this.sigar.getProcCred(pid);
            query.append(",").append("Cred.Uid.eq=" + cred.getUid());
            query.append(",").append("Cred.Gid.eq=" + cred.getGid());
            if (this.finder.find(query).length == 1) {
                return query.toString();
            }
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            String[] args = this.sigar.getProcArgs(pid);
            for (int i = args.length - 1; i >= 0; --i) {
                int j = i == args.length - 1 ? -1 : i;
                query.append(",").append("Args." + j + ".eq=" + args[i]);
                if (this.finder.find(query).length != 1) continue;
                return query.toString();
            }
        }
        catch (SigarException e) {
            // empty catch block
        }
        return null;
    }
}

