/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.ptql;

import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.ptql.StringPattern;

public class ProcessQueryHelper {
    static HashMap stringMatchers = new HashMap();

    public static String getProcEnv(SigarProxy proxy, long pid, String key) throws SigarException, SigarNotImplementedException {
        Map vars;
        try {
            vars = proxy.getProcEnv(pid);
        }
        catch (SigarNotImplementedException e) {
            throw e;
        }
        catch (SigarException e) {
            return "";
        }
        String val = (String)vars.get(key);
        if (val == null) {
            return "";
        }
        return val;
    }

    public static String getProcArg(SigarProxy proxy, long pid, int num) throws SigarException, SigarNotImplementedException {
        String[] args;
        try {
            args = proxy.getProcArgs(pid);
        }
        catch (SigarNotImplementedException e) {
            throw e;
        }
        catch (SigarException e) {
            return "";
        }
        if (num < 0) {
            num += args.length;
        }
        if (num >= args.length || num < 0) {
            return "";
        }
        return args[num];
    }

    public static boolean argsMatch(SigarProxy proxy, long pid, String value, String op) throws SigarException, SigarNotImplementedException {
        String[] args = proxy.getProcArgs(pid);
        StringMatcher matcher = (StringMatcher)stringMatchers.get(op);
        for (int i = 0; i < args.length; ++i) {
            if (!matcher.match(args[i], value)) continue;
            return true;
        }
        return false;
    }

    static {
        stringMatchers.put("eq", new StringEqMatcher());
        stringMatchers.put("ne", new StringNeMatcher());
        stringMatchers.put("sw", new StringSwMatcher());
        stringMatchers.put("ew", new StringEwMatcher());
        stringMatchers.put("re", new StringReMatcher());
        stringMatchers.put("ct", new StringCtMatcher());
    }

    static class StringReMatcher
    implements StringMatcher {
        StringReMatcher() {
        }

        public boolean match(String left, String right) {
            return StringPattern.matches(left, right);
        }
    }

    static class StringCtMatcher
    implements StringMatcher {
        StringCtMatcher() {
        }

        public boolean match(String left, String right) {
            return left.indexOf(right) != -1;
        }
    }

    static class StringSwMatcher
    implements StringMatcher {
        StringSwMatcher() {
        }

        public boolean match(String left, String right) {
            return left.startsWith(right);
        }
    }

    static class StringEwMatcher
    implements StringMatcher {
        StringEwMatcher() {
        }

        public boolean match(String left, String right) {
            return left.endsWith(right);
        }
    }

    static class StringNeMatcher
    implements StringMatcher {
        StringNeMatcher() {
        }

        public boolean match(String left, String right) {
            return !left.equals(right);
        }
    }

    static class StringEqMatcher
    implements StringMatcher {
        StringEqMatcher() {
        }

        public boolean match(String left, String right) {
            return left.equals(right);
        }
    }

    public static interface StringMatcher {
        public boolean match(String var1, String var2);
    }
}

