/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.ptql.MalformedQueryException;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.sigar.ptql.ProcessQuery;
import org.hyperic.sigar.ptql.ProcessQueryFactory;
import org.hyperic.sigar.ptql.QueryLoadException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestPTQL
extends SigarTestCase {
    private static final String[] OK_QUERIES = new String[]{"State.Name.eq=java", "Exe.Name.ew=java", "State.Name.eq=java,Exe.Cwd.eq=$user.dir", "State.Name.ne=java,Exe.Cwd.eq=$user.dir", "State.Name.sw=httpsd,State.Name.Pne=$1", "State.Name.ct=ssh", "State.Name.eq=java,Args.-1.ew=AgentClient", "Cred.Uid.eq=1003,State.Name.eq=java,Args.-1.ew=AgentClient", "Cred.Uid.gt=0,Cred.Uid.lt=1000", "Cred.Uid.eq=1003,Cred.Gid.eq=1003", "CredName.User.eq=dougm", "Time.Sys.gt=1000", "Fd.Total.gt=20", "Mem.Size.ge=10000000,Mem.Share.le=1000000", "State.Name.eq=sshd,Cred.Uid.eq=0", "State.Name.eq=crond,Cred.Uid.eq=0", "State.State.eq=R", "Args.0.eq=sendmail: accepting connections", "Args.0.sw=sendmail: Queue runner@", "Args.1000.eq=foo", "Args.*.eq=org.apache.tools.ant.Main", "Args.*.ct=java", "Args.*.ew=sigar.jar", "Port.tcp.eq=80,Cred.Uid.eq=0", "Port.udp.eq=161,Cred.Uid.eq=0", "Port.tcp.eq=8080,Cred.Uid.eq=1003", "Pid.PidFile.eq=pid.file", "Pid.Pid.eq=1", "Pid.Service.eq=Eventlog", "Pid.Service.eq=NOSUCHSERVICE", "Pid.Service.eq=Hyperic HQ Agent", "State.Name.eq=java,Pid.Pid.ne=$$", "Cpu.Percent.ge=0.2", "State.Name.sw=java,Args.*.eq=org.jboss.Main", "State.Name.eq=java,Args.*.eq=com.ibm.ws.runtime.WsServer", "State.Name.eq=java,Args.-1.eq=weblogic.Server"};
    private static final String[] OK_RE_QUERIES = new String[]{"Args.-1.eq=weblogic.Server,Env.WEBLOGIC_CLASSPATH.re=.*weblogic.jar.*", "State.Name.re=https?d.*|[Aa]pache2?$,State.Name.Pne=$1", "State.Name.re=post(master|gres),State.Name.Pne=$1,Args.0.re=.*post(master|gres)$"};
    private static final String[] MALFORMED_QUERIES = new String[]{"foo", "State.Name", "State.Name.eq", "State.Namex.eq=foo", "Statex.Name.eq=foo", "State.Name.eqx=foo", "State.Name.Xeq=foo", "State.Name.eq=$2", "State.State.eq=read", "Args.x.eq=foo", "Time.Sys.gt=x", "Pid.Pid.eq=foo", "Cpu.Percent.ge=x", "Port.foo.eq=8080", "", null};
    private static final String[] LOAD_FAIL_QUERIES = new String[0];

    public TestPTQL(String name) {
        super(name);
    }

    private int runQuery(SigarProxy proxy, String qs) throws MalformedQueryException, QueryLoadException, SigarException {
        ProcessQuery query;
        try {
            query = ProcessQueryFactory.getInstance(qs);
        }
        catch (MalformedQueryException e) {
            this.traceln("parse error: " + qs);
            throw e;
        }
        ProcessFinder finder = new ProcessFinder(proxy);
        try {
            long[] pids = finder.find(query);
            this.traceln(pids.length + " processes match: " + qs);
            if (pids.length == 1) {
                long pid = finder.findSingleProcess(query);
                TestPTQL.assertTrue((String)(pid + "==" + pids[0]), (pid == pids[0] ? 1 : 0) != 0);
            }
            return pids.length;
        }
        catch (SigarNotImplementedException e) {
            return 0;
        }
    }

    private void testOK(SigarProxy proxy) throws Exception {
        for (int i = 0; i < OK_QUERIES.length; ++i) {
            String qs;
            TestPTQL.assertTrue((String)qs, (this.runQuery(proxy, qs = OK_QUERIES[i]) >= 0 ? 1 : 0) != 0);
        }
    }

    private void testReOK(SigarProxy proxy) throws Exception {
        for (int i = 0; i < OK_RE_QUERIES.length; ++i) {
            String qs;
            TestPTQL.assertTrue((String)qs, (this.runQuery(proxy, qs = OK_RE_QUERIES[i]) >= 0 ? 1 : 0) != 0);
        }
    }

    private void testMalformed(SigarProxy proxy) throws Exception {
        for (int i = 0; i < MALFORMED_QUERIES.length; ++i) {
            String qs = MALFORMED_QUERIES[i];
            try {
                this.runQuery(proxy, qs);
                TestPTQL.fail((String)("'" + qs + "' did not throw MalformedQueryException"));
                continue;
            }
            catch (MalformedQueryException e) {
                this.traceln(qs + ": " + e.getMessage());
                TestPTQL.assertTrue((String)(qs + " Malformed"), (boolean)true);
            }
        }
    }

    private void testLoadFailure(SigarProxy proxy) throws Exception {
        for (int i = 0; i < LOAD_FAIL_QUERIES.length; ++i) {
            String qs = LOAD_FAIL_QUERIES[i];
            try {
                this.runQuery(proxy, qs);
                TestPTQL.fail((String)(qs + " did not throw QueryLoadException"));
                continue;
            }
            catch (QueryLoadException e) {
                this.traceln(qs + ": " + e.getMessage());
                TestPTQL.assertTrue((String)(qs + " QueryLoad"), (boolean)true);
            }
        }
    }

    public void testCreate() throws Exception {
        SigarProxy proxy = SigarProxyCache.newInstance(this.getSigar());
        this.testOK(proxy);
        if (JDK_14_COMPAT) {
            this.testReOK(proxy);
        }
        this.testMalformed(proxy);
        this.testLoadFailure(proxy);
    }
}

