/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.vmware;

import org.hyperic.sigar.vmware.ConnectParams;
import org.hyperic.sigar.vmware.VMwareException;
import org.hyperic.sigar.vmware.VMwareObject;

public class VM
extends VMwareObject {
    public static final int EXECUTION_STATE_ON = 1;
    public static final int EXECUTION_STATE_OFF = 2;
    public static final int EXECUTION_STATE_SUSPENDED = 3;
    public static final int EXECUTION_STATE_STUCK = 4;
    public static final int EXECUTION_STATE_UNKNOWN = 5;
    public static final String[] EXECUTION_STATES = new String[]{"INVALID", "ON", "OFF", "SUSPENDED", "STUCK", "UNKNOWN"};
    public static final int POWEROP_MODE_HARD = 1;
    public static final int POWEROP_MODE_SOFT = 2;
    public static final int POWEROP_MODE_TRYSOFT = 3;
    private static final int POWEROP_MODE_DEFAULT = 3;
    public static final int PRODUCT_WS = 1;
    public static final int PRODUCT_GSX = 2;
    public static final int PRODUCT_ESX = 3;
    public static final int PRODUCT_SERVER = 4;
    public static final int PRODUCT_UNKNOWN = 5;
    public static final String GSX = "GSX";
    public static final String ESX = "ESX";
    public static final String SERVER = "Server";
    public static final String[] PRODUCTS = new String[]{"INVALID", "Workstation", "GSX", "ESX", "Server", "UNKNOWN"};
    public static final int PLATFORM_WINDOWS = 1;
    public static final int PLATFORM_LINUX = 2;
    public static final int PLATFORM_VMNIX = 3;
    public static final int PLATFORM_UNKNOWN = 4;
    public static final String[] PLATFORMS = new String[]{"INVALID", "Windows", "Linux", "VmNix", "UNKNOWN"};
    public static final int PRODINFO_PRODUCT = 1;
    public static final int PRODINFO_PLATFORM = 2;
    public static final int PRODINFO_BUILD = 3;
    public static final int PRODINFO_VERSION_MAJOR = 4;
    public static final int PRODINFO_VERSION_MINOR = 5;
    public static final int PRODINFO_VERSION_REVISION = 6;
    public static final int PERM_READ = 4;
    public static final int PERM_WRITE = 2;
    public static final int PERM_EXECUTE = 1;

    native void destroy();

    private static native int create();

    private native void connect(ConnectParams var1, String var2, int var3) throws VMwareException;

    public void connect(ConnectParams params, String config, boolean mks) throws VMwareException {
        this.connect(params, config, mks ? 1 : 0);
    }

    public void connect(ConnectParams params, String config) throws VMwareException {
        this.connect(params, config, 0);
    }

    public native void disconnect();

    public native boolean isConnected();

    public native int getExecutionState() throws VMwareException;

    public native int getRemoteConnections() throws VMwareException;

    public native int getUptime() throws VMwareException;

    public native int getHeartbeat() throws VMwareException;

    public native int getToolsLastActive() throws VMwareException;

    public native String getRunAsUser() throws VMwareException;

    public native int getPermissions() throws VMwareException;

    public String getPermissionsString() {
        char[] perms = new char[]{'-', '-', '-'};
        try {
            int bits = this.getPermissions();
            if ((bits & 4) != 0) {
                perms[0] = 114;
            }
            if ((bits & 2) != 0) {
                perms[1] = 119;
            }
            if ((bits & 1) != 0) {
                perms[2] = 120;
            }
        }
        catch (VMwareException vMwareException) {
            // empty catch block
        }
        return new String(perms);
    }

    private boolean checkPermission(int perm) {
        try {
            return (this.getPermissions() & perm) != 0;
        }
        catch (VMwareException e) {
            return false;
        }
    }

    public boolean canRead() {
        return this.checkPermission(4);
    }

    public boolean canWrite() {
        return this.checkPermission(2);
    }

    public boolean canExecute() {
        return this.checkPermission(1);
    }

    public native String getConfig(String var1) throws VMwareException;

    public native String getResource(String var1) throws VMwareException;

    public native String getGuestInfo(String var1) throws VMwareException;

    public native void setGuestInfo(String var1, String var2) throws VMwareException;

    public native int getProductInfo(int var1) throws VMwareException;

    public native long getPid() throws VMwareException;

    public native int getId() throws VMwareException;

    public String getVersion() throws VMwareException {
        return this.getProductInfo(4) + "." + this.getProductInfo(5);
    }

    public String getFullVersion() throws VMwareException {
        return this.getVersion() + "." + this.getProductInfo(6) + "." + this.getProductInfo(3);
    }

    private String getConfigEx(String key) {
        try {
            return this.getConfig(key);
        }
        catch (VMwareException e) {
            return null;
        }
    }

    public String getDisplayName() {
        return this.getConfigEx("displayName");
    }

    public String getGuestOS() {
        return this.getConfigEx("guestOS");
    }

    public String getMemSize() {
        return this.getConfigEx("memsize");
    }

    public String getProductName() {
        try {
            int info = this.getProductInfo(1);
            return PRODUCTS[info] + " " + this.getVersion();
        }
        catch (VMwareException e) {
            return null;
        }
    }

    public String getProductPlatform() {
        try {
            int info = this.getProductInfo(2);
            return PLATFORMS[info];
        }
        catch (VMwareException e) {
            return null;
        }
    }

    private boolean isState(int state) {
        try {
            return this.getExecutionState() == state;
        }
        catch (VMwareException e) {
            return false;
        }
    }

    public boolean isOn() {
        return this.isState(1);
    }

    public boolean isOff() {
        return this.isState(2);
    }

    public boolean isSuspended() {
        return this.isState(3);
    }

    public boolean isStuck() {
        return this.isState(4);
    }

    public boolean isESX() {
        try {
            return this.getProductInfo(1) == 3;
        }
        catch (VMwareException e) {
            return false;
        }
    }

    public boolean isGSX() {
        try {
            return this.getProductInfo(1) == 2;
        }
        catch (VMwareException e) {
            return false;
        }
    }

    public native void start(int var1) throws VMwareException;

    public void start() throws VMwareException {
        this.start(3);
    }

    public native void stop(int var1) throws VMwareException;

    public void stop() throws VMwareException {
        this.stop(3);
    }

    public native void reset(int var1) throws VMwareException;

    public void reset() throws VMwareException {
        this.reset(3);
    }

    public native void suspend(int var1) throws VMwareException;

    public void suspend() throws VMwareException {
        this.suspend(3);
    }

    public void resume(int mode) throws VMwareException {
        int state = this.getExecutionState();
        if (state != 3) {
            throw new VMwareException("VM state is not suspended: " + EXECUTION_STATES[state]);
        }
        this.start(mode);
    }

    public void resume() throws VMwareException {
        this.resume(3);
    }

    public native void createSnapshot(String var1, String var2, boolean var3, boolean var4) throws VMwareException;

    public native void revertToSnapshot() throws VMwareException;

    public native void removeAllSnapshots() throws VMwareException;

    public native boolean hasSnapshot() throws VMwareException;

    public native void saveScreenshot(String var1) throws VMwareException;

    public native void deviceConnect(String var1) throws VMwareException;

    public native void deviceDisconnect(String var1) throws VMwareException;

    public native boolean deviceIsConnected(String var1) throws VMwareException;

    public VM() {
        this.ptr = VM.create();
    }
}

