/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.vmware;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.vmware.VMwareObject;
import org.hyperic.sigar.win32.RegistryKey;
import org.hyperic.sigar.win32.Win32Exception;

public class VMControlLibrary {
    public static final String REGISTRY_ROOT = "SOFTWARE\\VMware, Inc.";
    public static final String PROP_VMCONTROL_SHLIB = "vmcontrol.shlib";
    private static final String VMWARE_LIB = VMControlLibrary.getProperty("lib.vmware", VMControlLibrary.getVMwareLib().getPath());
    private static final String VMCONTROL_TAR = VMControlLibrary.getProperty("control.tar", VMWARE_LIB + "/perl/control.tar");
    private static final String VMCONTROL = "vmcontrol";
    private static final String VMCONTROL_DLL = "vmcontrollib.dll";
    private static final String VMCONTROL_SO = "vmcontrol.so";
    private static final String VMCONTROL_OBJ = VMControlLibrary.getProperty("vmcontrol.o", "control-only/vmcontrol.o");
    private static final String GCC = VMControlLibrary.getProperty("bin.gcc", "/usr/bin/gcc");
    private static final String TAR = VMControlLibrary.getProperty("bin.tar", "/bin/tar");
    private static final String LIBSSL = VMControlLibrary.getProperty("libssl", "libssl.so.0.9.7");
    private static final String LIBCRYPTO = VMControlLibrary.getProperty("libcrypto", "libcrypto.so.0.9.7");
    private static boolean isDebug = false;

    private static String getProperty(String key, String defval) {
        return System.getProperty("vmcontrol." + key, defval);
    }

    private static File getVMwareLib() {
        String location = "/usr/lib/vmware";
        File lib = new File(location);
        if (lib.exists()) {
            return lib;
        }
        return new File(location + "-api");
    }

    private static File getLib(String name) {
        File lib = new File(VMWARE_LIB, "lib/" + name);
        if (lib.isDirectory()) {
            lib = new File(lib, name);
        }
        return lib;
    }

    private static File getLibSSL() {
        return VMControlLibrary.getLib(LIBSSL);
    }

    private static File getLibCrypto() {
        return VMControlLibrary.getLib(LIBCRYPTO);
    }

    private static String toString(String[] args) {
        StringBuffer cmd = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (cmd.length() != 0) {
                cmd.append(' ');
            }
            cmd.append("'").append(args[i]).append("'");
        }
        return cmd.toString();
    }

    private static void exec(String[] args) throws IOException {
        Process proc = Runtime.getRuntime().exec(args);
        try {
            int exitVal = proc.waitFor();
            if (exitVal != 0) {
                String msg = "exec(" + VMControlLibrary.toString(args) + ") failed: " + exitVal;
                throw new IOException(msg);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (isDebug) {
            System.out.println("exec(" + VMControlLibrary.toString(args) + ") OK");
        }
    }

    public static String getSharedLibrary() {
        return System.getProperty(PROP_VMCONTROL_SHLIB);
    }

    public static void setSharedLibrary(String lib) {
        System.setProperty(PROP_VMCONTROL_SHLIB, lib);
    }

    public static void link() throws IOException {
        VMControlLibrary.link(VMCONTROL_SO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void linkWin32() {
        ArrayList<String> dlls = new ArrayList<String>();
        RegistryKey root = null;
        try {
            root = RegistryKey.LocalMachine.openSubKey(REGISTRY_ROOT);
            String[] keys = root.getSubKeyNames();
            for (int i = 0; i < keys.length; ++i) {
                String name = keys[i];
                if (!name.startsWith("VMware ")) continue;
                RegistryKey subkey = null;
                try {
                    File dll;
                    subkey = root.openSubKey(name);
                    String path = subkey.getStringValue("InstallPath");
                    if (path == null || (path = path.trim()).length() == 0 || !(dll = new File(path + VMCONTROL_DLL)).exists()) continue;
                    if (name.endsWith(" Server")) {
                        dlls.add(0, dll.getPath());
                        continue;
                    }
                    if (!name.endsWith(" API")) continue;
                    dlls.add(dll.getPath());
                    continue;
                }
                catch (Win32Exception e) {
                    continue;
                }
                finally {
                    if (subkey != null) {
                        subkey.close();
                    }
                }
            }
        }
        catch (Win32Exception win32Exception) {
        }
        finally {
            if (root != null) {
                root.close();
            }
        }
        if (dlls.size() != 0) {
            VMControlLibrary.setSharedLibrary((String)dlls.get(0));
        }
    }

    public static void link(String name) throws IOException {
        boolean exists;
        if (SigarLoader.IS_WIN32) {
            VMControlLibrary.linkWin32();
            return;
        }
        File out = new File(name).getAbsoluteFile();
        if (out.isDirectory()) {
            out = new File(out, VMCONTROL_SO);
        }
        if (exists = out.exists()) {
            VMControlLibrary.setSharedLibrary(out.getPath());
            return;
        }
        if (!new File(VMCONTROL_TAR).exists()) {
            return;
        }
        File dir = out.getParentFile();
        if (!dir.isDirectory() || !dir.canWrite()) {
            throw new IOException("Cannot write to: " + dir);
        }
        File libssl = VMControlLibrary.getLibSSL();
        File libcrypto = VMControlLibrary.getLibCrypto();
        if (!libssl.exists()) {
            throw new FileNotFoundException(libssl.toString());
        }
        File obj = new File(dir, VMCONTROL_OBJ);
        if (!obj.exists()) {
            String[] extract_args = new String[]{TAR, "-xf", VMCONTROL_TAR, "-C", dir.toString(), VMCONTROL_OBJ};
            VMControlLibrary.exec(extract_args);
        }
        ArrayList<String> link_args = new ArrayList<String>();
        link_args.add(GCC);
        link_args.add("-shared");
        link_args.add("-o");
        link_args.add(out.getPath());
        link_args.add(obj.getPath());
        if (!new File(libssl.getParent(), "libc.so.6").exists()) {
            String rpath = "-Wl,-rpath";
            link_args.add("-Wl,-rpath");
            link_args.add(libssl.getParent());
            if (!libssl.getParent().equals(libcrypto.getParent())) {
                link_args.add("-Wl,-rpath");
                link_args.add(libcrypto.getParent());
            }
        }
        link_args.add(libssl.getPath());
        link_args.add(libcrypto.getPath());
        VMControlLibrary.exec(link_args.toArray(new String[0]));
        VMControlLibrary.setSharedLibrary(out.getPath());
    }

    public static boolean isLoaded() {
        return VMwareObject.LOADED;
    }

    public static void main(String[] args) throws Exception {
        isDebug = true;
        if (args.length == 0) {
            VMControlLibrary.link();
        } else {
            VMControlLibrary.link(args[0]);
        }
        String shlib = VMControlLibrary.getSharedLibrary();
        if (shlib == null) {
            System.out.println("No library found");
        } else {
            System.out.println("vmcontrol.shlib=" + shlib + " (loaded=" + VMControlLibrary.isLoaded() + ")");
        }
    }
}

