/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.vmware;

import java.io.File;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.vmware.VMControlLibrary;

abstract class VMwareObject {
    public static final boolean LOADED = VMwareObject.loadLibraries();
    protected int ptr = 0;

    VMwareObject() {
    }

    private static native boolean init(String var0);

    private static boolean loadLibraries() {
        if (!SigarLoader.IS_LINUX && !SigarLoader.IS_WIN32) {
            return false;
        }
        try {
            Sigar.load();
            String lib = VMControlLibrary.getSharedLibrary();
            if (lib == null) {
                return false;
            }
            if (SigarLoader.IS_WIN32) {
                File root = new File(lib).getParentFile();
                String[] libs = new String[]{"libeay32.dll", "ssleay32.dll"};
                for (int i = 0; i < libs.length; ++i) {
                    File ssllib = new File(root, libs[i]);
                    if (!ssllib.exists()) {
                        return false;
                    }
                    try {
                        System.load(ssllib.getPath());
                        continue;
                    }
                    catch (UnsatisfiedLinkError e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }
            return VMwareObject.init(lib);
        }
        catch (Exception e) {
            return false;
        }
    }

    abstract void destroy();

    public void dispose() {
        if (this.ptr != 0) {
            this.destroy();
            this.ptr = 0;
        }
    }

    protected void finalize() {
        this.dispose();
    }
}

