/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.io.File;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public abstract class Win32 {
    public static native String findExecutable(String var0) throws SigarException;

    public static String findScriptExecutable(String name) {
        String exe;
        int ix = name.lastIndexOf(".");
        if (ix == -1) {
            return null;
        }
        String ext = name.substring(ix + 1);
        if (ext.equals("exe") || ext.equals("bat") || ext.equals("com")) {
            return null;
        }
        try {
            exe = Win32.findExecutable(new File(name).getAbsolutePath());
        }
        catch (SigarException e) {
            return null;
        }
        if (exe == null) {
            return null;
        }
        if ((exe = exe.toLowerCase()).equals(name = name.toLowerCase()) || exe.endsWith(name)) {
            return null;
        }
        File file = new File(exe);
        if (file.getName().equals("wscript.exe")) {
            exe = file.getParent() + File.separator + "cscript.exe";
        }
        return exe;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String file = new File(args[i]).getAbsoluteFile().toString();
            String exe = Win32.findScriptExecutable(file);
            if (exe == null) continue;
            System.out.println(args[i] + "=" + exe);
        }
    }

    static {
        try {
            Sigar.load();
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
    }
}

