/*
 * Copyright (C) [2004, 2005, 2006], Hyperic, Inc.
 * This file is part of SIGAR.
 * 
 * SIGAR is free software; you can redistribute it and/or modify
 * it under the terms version 2 of the GNU General Public License as
 * published by the Free Software Foundation. This program is distributed
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

package org.hyperic.sigar.cmd.vmware;

import org.hyperic.sigar.SigarException;

import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.vmware.ConnectParams;
import org.hyperic.sigar.vmware.VM;

public class VMware_ctl extends VMwareCommand {

    public VMware_ctl(Shell shell) {
        super(shell);
    }

    public VMware_ctl() {
        super();
    }

    public String getUsageShort() {
        return "Control vms";
    }

    public String getSyntaxArgs() {
        return "vm control";
    }

    protected boolean validateArgs(String[] args) {
        return args.length == 2;
    }

    public void output(String[] args) throws SigarException {
        VM vm = new VM();
        vm.connect(new ConnectParams(), args[1], true);
        String cmd = args[0];
        if (cmd.equals("createSnapshot")) {
            vm.createSnapshot(null, null, true, true);
        }
        else if (cmd.equals("deleteSnapshot")) {
            vm.removeAllSnapshots();
        }
        else if (cmd.equals("revertToSnapshot")) {
            vm.revertToSnapshot();
        }
        else {
            throw new SigarException("Unknown ctl: " + cmd);
        }
    }
}
