/*
 * Copyright (C) [2004, 2005, 2006], Hyperic, Inc.
 * This file is part of SIGAR.
 * 
 * SIGAR is free software; you can redistribute it and/or modify
 * it under the terms version 2 of the GNU General Public License as
 * published by the Free Software Foundation. This program is distributed
 * in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA.
 */

package org.hyperic.sigar.cmd.vmware;

import java.util.List;

import org.hyperic.sigar.SigarException;

import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.vmware.VMwareServer;

public class VMware_list extends VMwareCommand {

    public VMware_list(Shell shell) {
        super(shell);
    }

    public VMware_list() {
        super();
    }

    public String getUsageShort() {
        return "List vms";
    }

    public void output(String[] args) throws SigarException {
        VMwareServer server = getServer();
        List names = server.getRegisteredVmNames();
        for (int i=0; i<names.size(); i++) {
            String name = (String)names.get(i);
            println(name);
        }
    }
}
