/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import java.util.Date;

public class EventLogRecord {
    long recordNumber;
    long timeGenerated;
    long timeWritten;
    long eventId;
    short eventType;
    String source;
    String computerName;
    String user;
    String message;
    String logName;

    EventLogRecord() {
    }

    public String getLogName() {
        return this.logName;
    }

    void setLogName(String logName) {
        this.logName = logName;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public long getTimeGenerated() {
        return this.timeGenerated;
    }

    public long getTimeWritten() {
        return this.timeWritten;
    }

    public long getEventId() {
        return this.eventId;
    }

    public short getEventType() {
        return this.eventType;
    }

    public String getEventTypeString() {
        switch (this.eventType) {
            case 1: {
                return "Error";
            }
            case 2: {
                return "Warning";
            }
            case 4: {
                return "Information";
            }
            case 8: {
                return "Success Audit";
            }
            case 16: {
                return "Failure Audit";
            }
        }
        return "Unknown";
    }

    public String getSource() {
        return this.source;
    }

    public String getComputerName() {
        return this.computerName;
    }

    public String getUser() {
        return this.user;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStringData() {
        return this.getMessage();
    }

    public String toString() {
        return "[" + new Date(this.getTimeGenerated() * 1000L) + "] " + "[" + this.getEventTypeString() + "] " + "[" + this.getSource() + "] " + this.getMessage();
    }
}

