/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.hyperledger.fabric.gateway.GatewayException;
import org.hyperledger.fabric.sdk.ProposalResponse;

public class ContractException
extends GatewayException {
    private final byte[] payload;
    private Collection<ProposalResponse> proposalResponses;

    public ContractException(String message) {
        super(message);
        this.payload = null;
        this.proposalResponses = Collections.emptyList();
    }

    public ContractException(String message, Throwable cause) {
        super(message, cause);
        this.payload = null;
        this.proposalResponses = Collections.emptyList();
    }

    @Deprecated
    public ContractException(String message, byte[] payload) {
        super(message);
        this.payload = payload;
    }

    public ContractException(String message, Collection<ProposalResponse> proposalResponses) {
        super(message);
        this.payload = null;
        this.proposalResponses = proposalResponses;
    }

    @Deprecated
    public Optional<byte[]> getPayload() {
        return Optional.ofNullable(this.payload);
    }

    public Collection<ProposalResponse> getProposalResponses() {
        return new ArrayList<ProposalResponse>(this.proposalResponses);
    }

    public void setProposalResponses(Collection<ProposalResponse> proposalResponses) {
        this.proposalResponses = proposalResponses;
    }
}

