/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway;

import java.util.Collection;
import java.util.EnumSet;
import org.hyperledger.fabric.gateway.Network;
import org.hyperledger.fabric.gateway.impl.AllCommitStrategy;
import org.hyperledger.fabric.gateway.impl.AnyCommitStrategy;
import org.hyperledger.fabric.gateway.impl.CommitHandlerImpl;
import org.hyperledger.fabric.gateway.impl.NoOpCommitHandler;
import org.hyperledger.fabric.gateway.spi.CommitHandler;
import org.hyperledger.fabric.gateway.spi.CommitHandlerFactory;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;

public enum DefaultCommitHandlers implements CommitHandlerFactory
{
    NONE((transactionId, network) -> NoOpCommitHandler.INSTANCE),
    MSPID_SCOPE_ALLFORTX((transactionId, network) -> {
        Collection<Peer> peers = DefaultCommitHandlers.getEventSourcePeersForOrganization(network);
        AllCommitStrategy strategy = new AllCommitStrategy(peers);
        return new CommitHandlerImpl(transactionId, network, strategy);
    }),
    NETWORK_SCOPE_ALLFORTX((transactionId, network) -> {
        Collection<Peer> peers = DefaultCommitHandlers.getEventSourcePeers(network);
        AllCommitStrategy strategy = new AllCommitStrategy(peers);
        return new CommitHandlerImpl(transactionId, network, strategy);
    }),
    MSPID_SCOPE_ANYFORTX((transactionId, network) -> {
        Collection<Peer> peers = DefaultCommitHandlers.getEventSourcePeersForOrganization(network);
        AnyCommitStrategy strategy = new AnyCommitStrategy(peers);
        return new CommitHandlerImpl(transactionId, network, strategy);
    }),
    NETWORK_SCOPE_ANYFORTX((transactionId, network) -> {
        Collection<Peer> peers = DefaultCommitHandlers.getEventSourcePeers(network);
        AnyCommitStrategy strategy = new AnyCommitStrategy(peers);
        return new CommitHandlerImpl(transactionId, network, strategy);
    });

    private static final EnumSet<Peer.PeerRole> EVENT_SOURCE_ROLES;
    private final CommitHandlerFactory factory;

    private DefaultCommitHandlers(CommitHandlerFactory factory) {
        this.factory = factory;
    }

    private static Collection<Peer> getEventSourcePeersForOrganization(Network network) {
        Collection<Peer> eventSourcePeers = DefaultCommitHandlers.getEventSourcePeers(network);
        Collection<Peer> orgPeers = DefaultCommitHandlers.getPeersForOrganization(network);
        orgPeers.retainAll(eventSourcePeers);
        return orgPeers;
    }

    private static Collection<Peer> getPeersForOrganization(Network network) {
        String mspId = network.getGateway().getIdentity().getMspId();
        try {
            return network.getChannel().getPeersForOrganization(mspId);
        }
        catch (InvalidArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private static Collection<Peer> getEventSourcePeers(Network network) {
        return network.getChannel().getPeers(EVENT_SOURCE_ROLES);
    }

    @Override
    public CommitHandler create(String transactionId, Network network) {
        return this.factory.create(transactionId, network);
    }

    static {
        EVENT_SOURCE_ROLES = EnumSet.of(Peer.PeerRole.EVENT_SOURCE);
    }
}

