/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway;

import java.util.Collection;
import java.util.EnumSet;
import org.hyperledger.fabric.gateway.Network;
import org.hyperledger.fabric.gateway.impl.RoundRobinQueryHandler;
import org.hyperledger.fabric.gateway.impl.SingleQueryHandler;
import org.hyperledger.fabric.gateway.spi.QueryHandler;
import org.hyperledger.fabric.gateway.spi.QueryHandlerFactory;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;

public enum DefaultQueryHandlers implements QueryHandlerFactory
{
    MSPID_SCOPE_SINGLE(network -> {
        Collection<Peer> peers = DefaultQueryHandlers.getChaincodeQueryPeersForOrganization(network);
        return new SingleQueryHandler(peers);
    }),
    MSPID_SCOPE_ROUND_ROBIN(network -> {
        Collection<Peer> peers = DefaultQueryHandlers.getChaincodeQueryPeersForOrganization(network);
        return new RoundRobinQueryHandler(peers);
    });

    private static final EnumSet<Peer.PeerRole> QUERY_ROLES;
    private final QueryHandlerFactory factory;

    private DefaultQueryHandlers(QueryHandlerFactory factory) {
        this.factory = factory;
    }

    private static Collection<Peer> getChaincodeQueryPeersForOrganization(Network network) {
        Collection<Peer> queryPeers = DefaultQueryHandlers.getChaincodeQueryPeers(network);
        Collection<Peer> orgPeers = DefaultQueryHandlers.getPeersForOrganization(network);
        orgPeers.retainAll(queryPeers);
        return orgPeers;
    }

    private static Collection<Peer> getChaincodeQueryPeers(Network network) {
        return network.getChannel().getPeers(QUERY_ROLES);
    }

    private static Collection<Peer> getPeersForOrganization(Network network) {
        String mspId = network.getGateway().getIdentity().getMspId();
        try {
            return network.getChannel().getPeersForOrganization(mspId);
        }
        catch (InvalidArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryHandler create(Network network) {
        return this.factory.create(network);
    }

    static {
        QUERY_ROLES = EnumSet.of(Peer.PeerRole.CHAINCODE_QUERY);
    }
}

