/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import org.apache.commons.io.FileUtils;
import org.hyperledger.fabric.gateway.Wallet;

public final class FileSystemWallet
implements Wallet {
    private Path basePath;

    public FileSystemWallet(Path path) throws IOException {
        boolean walletExists = Files.isDirectory(path, new LinkOption[0]);
        if (!walletExists) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        this.basePath = path;
    }

    @Override
    public void put(String label, Wallet.Identity identity) throws IOException {
        Path idFolder = this.basePath.resolve(label);
        if (!Files.isDirectory(idFolder, new LinkOption[0])) {
            Files.createDirectories(idFolder, new FileAttribute[0]);
        }
        Path idFile = this.basePath.resolve(Paths.get(label, label));
        try (BufferedWriter fw = Files.newBufferedWriter(idFile, new OpenOption[0]);){
            String json = FileSystemWallet.toJson(label, identity);
            fw.append(json);
        }
        Path pemFile = this.basePath.resolve(Paths.get(label, label + "-priv"));
        FileSystemWallet.writePrivateKey(identity.getPrivateKey(), pemFile);
    }

    @Override
    public Wallet.Identity get(String label) throws IOException {
        Path idFile = this.basePath.resolve(Paths.get(label, label));
        if (Files.exists(idFile, new LinkOption[0])) {
            try (BufferedReader fr = Files.newBufferedReader(idFile);){
                String contents = fr.readLine();
                Wallet.Identity identity = this.fromJson(contents);
                return identity;
            }
        }
        return null;
    }

    @Override
    public Set<String> getAllLabels() {
        return Arrays.stream(this.basePath.toFile().listFiles(File::isDirectory)).map(File::getName).collect(Collectors.toSet());
    }

    @Override
    public void remove(String label) throws IOException {
        Path idDir = this.basePath.resolve(label);
        if (Files.exists(idDir, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)idDir.toFile());
        }
    }

    @Override
    public boolean exists(String label) {
        Path idFile = this.basePath.resolve(Paths.get(label, label));
        return Files.exists(idFile, new LinkOption[0]);
    }

    private Wallet.Identity fromJson(String json) throws IOException {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            JsonObject idObject = reader.readObject();
            String name = idObject.getString("name");
            String mspId = idObject.getString("mspid");
            JsonObject enrollment = idObject.getJsonObject("enrollment");
            String signingId = enrollment.getString("signingIdentity");
            Path pemFile = this.basePath.resolve(Paths.get(name, signingId + "-priv"));
            String certificate = enrollment.getJsonObject("identity").getString("certificate");
            Wallet.Identity identity = Wallet.Identity.createIdentity(mspId, new StringReader(certificate), Files.newBufferedReader(pemFile));
            return identity;
        }
    }

    private static String toJson(String name, Wallet.Identity identity) {
        String json = null;
        JsonObject idObject = Json.createObjectBuilder().add("name", name).add("type", "X509").add("mspid", identity.getMspId()).add("enrollment", Json.createObjectBuilder().add("signingIdentity", name).add("identity", Json.createObjectBuilder().add("certificate", identity.getCertificate()))).build();
        StringWriter writer = new StringWriter();
        try (JsonWriter jw = Json.createWriter((Writer)writer);){
            jw.writeObject(idObject);
        }
        json = writer.toString();
        return json;
    }

    private static void writePrivateKey(PrivateKey key, Path pemFile) throws IOException {
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(pemFile, new OpenOption[0]));){
            writer.println("-----BEGIN PRIVATE KEY-----");
            String base64 = Base64.getEncoder().encodeToString(key.getEncoded());
            Arrays.stream(base64.split("(?<=\\G.{64})")).forEachOrdered(line -> writer.println((String)line));
            writer.println("-----END PRIVATE KEY-----");
        }
    }
}

