/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.gateway.DefaultCommitHandlers;
import org.hyperledger.fabric.gateway.DefaultQueryHandlers;
import org.hyperledger.fabric.gateway.Gateway;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.Network;
import org.hyperledger.fabric.gateway.Wallet;
import org.hyperledger.fabric.gateway.impl.NetworkImpl;
import org.hyperledger.fabric.gateway.impl.TimePeriod;
import org.hyperledger.fabric.gateway.spi.CommitHandlerFactory;
import org.hyperledger.fabric.gateway.spi.QueryHandlerFactory;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.NetworkConfig;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.NetworkConfigurationException;
import org.hyperledger.fabric.sdk.identity.X509Enrollment;
import org.hyperledger.fabric.sdk.security.CryptoSuite;
import org.hyperledger.fabric.sdk.security.CryptoSuiteFactory;

public final class GatewayImpl
implements Gateway {
    private static final Log LOG = LogFactory.getLog(Gateway.class);
    private static final long DEFAULT_COMMIT_TIMEOUT = 5L;
    private static final TimeUnit DEFAULT_COMMIT_TIMEOUT_UNIT = TimeUnit.MINUTES;
    private final HFClient client;
    private final NetworkConfig networkConfig;
    private final Wallet.Identity identity;
    private final Map<String, NetworkImpl> networks = new HashMap<String, NetworkImpl>();
    private final CommitHandlerFactory commitHandlerFactory;
    private final TimePeriod commitTimeout;
    private final QueryHandlerFactory queryHandlerFactory;
    private final boolean discovery;

    private GatewayImpl(Builder builder) {
        this.commitHandlerFactory = builder.commitHandlerFactory;
        this.commitTimeout = builder.commitTimeout;
        this.queryHandlerFactory = builder.queryHandlerFactory;
        this.discovery = builder.discovery;
        if (builder.client != null) {
            this.client = builder.client;
            this.networkConfig = null;
            User user = this.client.getUserContext();
            Enrollment enrollment = user.getEnrollment();
            this.identity = Wallet.Identity.createIdentity(user.getMspId(), enrollment.getCert(), enrollment.getKey());
        } else {
            if (null == builder.identity) {
                throw new IllegalStateException("The gateway identity must be set");
            }
            if (null == builder.ccp) {
                throw new IllegalStateException("The network configuration must be specified");
            }
            this.networkConfig = builder.ccp;
            this.identity = builder.identity;
            this.client = this.createClient();
        }
    }

    private GatewayImpl(GatewayImpl that) {
        this.commitHandlerFactory = that.commitHandlerFactory;
        this.commitTimeout = that.commitTimeout;
        this.queryHandlerFactory = that.queryHandlerFactory;
        this.discovery = that.discovery;
        this.networkConfig = that.networkConfig;
        this.identity = that.identity;
        this.client = this.createClient();
    }

    private HFClient createClient() {
        X509Enrollment enrollment = new X509Enrollment(this.identity.getPrivateKey(), this.identity.getCertificate());
        User user = new User((Enrollment)enrollment){
            final /* synthetic */ Enrollment val$enrollment;
            {
                this.val$enrollment = enrollment;
            }

            public String getName() {
                return "gateway";
            }

            public Set<String> getRoles() {
                return Collections.emptySet();
            }

            public String getAccount() {
                return "";
            }

            public String getAffiliation() {
                return "";
            }

            public Enrollment getEnrollment() {
                return this.val$enrollment;
            }

            public String getMspId() {
                return GatewayImpl.this.identity.getMspId();
            }
        };
        HFClient client = HFClient.createNewInstance();
        try {
            CryptoSuite cryptoSuite = CryptoSuiteFactory.getDefault().getCryptoSuite();
            client.setCryptoSuite(cryptoSuite);
            client.setUserContext(user);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CryptoException | InvalidArgumentException e) {
            throw new GatewayRuntimeException("Failed to configure client", e);
        }
        return client;
    }

    @Override
    public synchronized void close() {
        this.networks.values().forEach(NetworkImpl::close);
        this.networks.clear();
    }

    @Override
    public synchronized Network getNetwork(String networkName) {
        if (networkName == null || networkName.isEmpty()) {
            throw new IllegalArgumentException("Channel name must be a non-empty string");
        }
        NetworkImpl network = this.networks.get(networkName);
        if (network == null) {
            Channel channel = this.client.getChannel(networkName);
            if (channel == null && this.networkConfig != null) {
                try {
                    channel = this.client.loadChannelFromConfig(networkName, this.networkConfig);
                }
                catch (InvalidArgumentException | NetworkConfigurationException ex) {
                    LOG.info((Object)("Unable to load channel configuration from connection profile: " + ex.getLocalizedMessage()));
                }
            }
            if (channel == null) {
                try {
                    channel = this.client.newChannel(networkName);
                    for (Peer peer : this.getPeersForOrg()) {
                        Channel.PeerOptions peerOptions = Channel.PeerOptions.createPeerOptions().setPeerRoles(EnumSet.allOf(Peer.PeerRole.class));
                        channel.addPeer(peer, peerOptions);
                    }
                }
                catch (InvalidArgumentException e) {
                    throw new GatewayRuntimeException(e);
                }
            }
            network = new NetworkImpl(channel, this);
            this.networks.put(networkName, network);
        }
        return network;
    }

    @Override
    public Wallet.Identity getIdentity() {
        return this.identity;
    }

    public HFClient getClient() {
        return this.client;
    }

    public CommitHandlerFactory getCommitHandlerFactory() {
        return this.commitHandlerFactory;
    }

    public TimePeriod getCommitTimeout() {
        return this.commitTimeout;
    }

    public QueryHandlerFactory getQueryHandlerFactory() {
        return this.queryHandlerFactory;
    }

    public boolean isDiscoveryEnabled() {
        return this.discovery;
    }

    public GatewayImpl newInstance() {
        return new GatewayImpl(this);
    }

    private Collection<Peer> getPeersForOrg() {
        ArrayList<Peer> peers = new ArrayList<Peer>();
        List peerNames = this.networkConfig.getClientOrganization().getPeerNames();
        for (String name : peerNames) {
            try {
                String url = this.networkConfig.getPeerUrl(name);
                Properties props = this.networkConfig.getPeerProperties(name);
                peers.add(this.client.newPeer(name, url, props));
            }
            catch (InvalidArgumentException invalidArgumentException) {}
        }
        return peers;
    }

    static /* synthetic */ TimeUnit access$000() {
        return DEFAULT_COMMIT_TIMEOUT_UNIT;
    }

    public static final class Builder
    implements Gateway.Builder {
        private CommitHandlerFactory commitHandlerFactory = DefaultCommitHandlers.MSPID_SCOPE_ALLFORTX;
        private TimePeriod commitTimeout = new TimePeriod(5L, GatewayImpl.access$000());
        private QueryHandlerFactory queryHandlerFactory = DefaultQueryHandlers.MSPID_SCOPE_SINGLE;
        private NetworkConfig ccp = null;
        private Wallet.Identity identity = null;
        private HFClient client;
        private boolean discovery = false;

        /*
         * Exception decompiling
         */
        @Override
        public Builder networkConfig(Path config) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public Builder networkConfig(InputStream config) throws IOException {
            try (InputStream bufferedStream = this.copyToMemory(config);){
                try {
                    this.ccp = NetworkConfig.fromJsonStream((InputStream)bufferedStream);
                }
                catch (Exception e) {
                    bufferedStream.reset();
                    this.ccp = NetworkConfig.fromYamlStream((InputStream)bufferedStream);
                }
            }
            catch (InvalidArgumentException | NetworkConfigurationException e) {
                throw new IOException(e);
            }
            return this;
        }

        private InputStream copyToMemory(InputStream in) throws IOException {
            int b;
            ExposedByteArrayOutputStream outBuff = new ExposedByteArrayOutputStream();
            while ((b = in.read()) > -1) {
                outBuff.write(b);
            }
            return new ByteArrayInputStream(outBuff.getInternalBuffer(), 0, outBuff.size());
        }

        @Override
        public Builder identity(Wallet wallet, String id) throws IOException {
            this.identity = wallet.get(id);
            return this;
        }

        @Override
        public Builder commitHandler(CommitHandlerFactory commitHandlerFactory) {
            this.commitHandlerFactory = commitHandlerFactory;
            return this;
        }

        @Override
        public Builder queryHandler(QueryHandlerFactory queryHandler) {
            this.queryHandlerFactory = queryHandler;
            return this;
        }

        @Override
        public Builder commitTimeout(long timeout, TimeUnit timeUnit) {
            this.commitTimeout = new TimePeriod(timeout, timeUnit);
            return this;
        }

        @Override
        public Builder discovery(boolean enabled) {
            this.discovery = enabled;
            return this;
        }

        public Builder client(HFClient client) {
            this.client = client;
            return this;
        }

        @Override
        public GatewayImpl connect() {
            return new GatewayImpl(this);
        }

        private static final class ExposedByteArrayOutputStream
        extends ByteArrayOutputStream {
            private ExposedByteArrayOutputStream() {
            }

            public byte[] getInternalBuffer() {
                return this.buf;
            }
        }
    }
}

