/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.gateway.ContractException;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.Transaction;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.gateway.impl.GatewayImpl;
import org.hyperledger.fabric.gateway.impl.NetworkImpl;
import org.hyperledger.fabric.gateway.impl.QueryImpl;
import org.hyperledger.fabric.gateway.impl.TimePeriod;
import org.hyperledger.fabric.gateway.spi.CommitHandler;
import org.hyperledger.fabric.gateway.spi.CommitHandlerFactory;
import org.hyperledger.fabric.gateway.spi.QueryHandler;
import org.hyperledger.fabric.sdk.ChaincodeID;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.QueryByChaincodeRequest;
import org.hyperledger.fabric.sdk.ServiceDiscovery;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.TransactionRequest;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.exception.ServiceDiscoveryException;

public final class TransactionImpl
implements Transaction {
    private static final Log LOG = LogFactory.getLog(TransactionImpl.class);
    private static final long DEFAULT_ORDERER_TIMEOUT = 60L;
    private static final TimeUnit DEFAULT_ORDERER_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final ContractImpl contract;
    private final String name;
    private final NetworkImpl network;
    private final Channel channel;
    private final GatewayImpl gateway;
    private final CommitHandlerFactory commitHandlerFactory;
    private TimePeriod commitTimeout;
    private final QueryHandler queryHandler;
    private Map<String, byte[]> transientData = null;
    private Collection<Peer> endorsingPeers = null;

    TransactionImpl(ContractImpl contract, String name) {
        this.contract = contract;
        this.name = name;
        this.network = contract.getNetwork();
        this.channel = this.network.getChannel();
        this.gateway = this.network.getGateway();
        this.commitHandlerFactory = this.gateway.getCommitHandlerFactory();
        this.commitTimeout = this.gateway.getCommitTimeout();
        this.queryHandler = this.network.getQueryHandler();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Transaction setTransient(Map<String, byte[]> transientData) {
        this.transientData = transientData;
        return this;
    }

    @Override
    public Transaction setCommitTimeout(long timeout, TimeUnit timeUnit) {
        this.commitTimeout = new TimePeriod(timeout, timeUnit);
        return this;
    }

    @Override
    public Transaction setEndorsingPeers(Collection<Peer> peers) {
        this.endorsingPeers = peers;
        return this;
    }

    @Override
    public byte[] submit(String ... args) throws ContractException, TimeoutException, InterruptedException {
        Collection<ProposalResponse> proposalResponses = this.endorseTransaction(args);
        Collection<ProposalResponse> validResponses = this.validatePeerResponses(proposalResponses);
        try {
            return this.commitTransaction(validResponses);
        }
        catch (ContractException e) {
            e.setProposalResponses(proposalResponses);
            throw e;
        }
    }

    private Collection<ProposalResponse> endorseTransaction(String ... args) {
        try {
            TransactionProposalRequest request = this.newProposalRequest(args);
            return this.sendTransactionProposal(request);
        }
        catch (InvalidArgumentException | ProposalException | ServiceDiscoveryException e) {
            throw new GatewayRuntimeException(e);
        }
    }

    private Collection<ProposalResponse> sendTransactionProposal(TransactionProposalRequest request) throws ProposalException, InvalidArgumentException, ServiceDiscoveryException {
        if (this.endorsingPeers != null) {
            return this.channel.sendTransactionProposal(request, this.endorsingPeers);
        }
        if (this.network.getGateway().isDiscoveryEnabled()) {
            Channel.DiscoveryOptions discoveryOptions = Channel.DiscoveryOptions.createDiscoveryOptions().setEndorsementSelector(ServiceDiscovery.EndorsementSelector.ENDORSEMENT_SELECTION_RANDOM).setInspectResults(true).setForceDiscovery(true);
            return this.channel.sendTransactionProposalToEndorsers(request, discoveryOptions);
        }
        return this.channel.sendTransactionProposal(request);
    }

    private byte[] commitTransaction(Collection<ProposalResponse> validResponses) throws TimeoutException, ContractException, InterruptedException {
        ProposalResponse proposalResponse = validResponses.iterator().next();
        String transactionId = proposalResponse.getTransactionID();
        CommitHandler commitHandler = this.commitHandlerFactory.create(transactionId, this.network);
        commitHandler.startListening();
        try {
            Channel.TransactionOptions transactionOptions = Channel.TransactionOptions.createTransactionOptions().nOfEvents(Channel.NOfEvents.createNoEvents());
            this.channel.sendTransaction(validResponses, transactionOptions).get(60L, DEFAULT_ORDERER_TIMEOUT_UNIT);
        }
        catch (TimeoutException e) {
            commitHandler.cancelListening();
            throw e;
        }
        catch (Exception e) {
            commitHandler.cancelListening();
            throw new ContractException("Failed to send transaction to the orderer", e);
        }
        commitHandler.waitForEvents(this.commitTimeout.getTime(), this.commitTimeout.getTimeUnit());
        try {
            return proposalResponse.getChaincodeActionResponsePayload();
        }
        catch (InvalidArgumentException e) {
            throw new GatewayRuntimeException(e);
        }
    }

    private TransactionProposalRequest newProposalRequest(String ... args) {
        TransactionProposalRequest request = this.network.getGateway().getClient().newTransactionProposalRequest();
        this.configureRequest((TransactionRequest)request, args);
        if (this.transientData != null) {
            try {
                request.setTransientMap(this.transientData);
            }
            catch (InvalidArgumentException e) {
                throw new IllegalStateException(e);
            }
        }
        return request;
    }

    private void configureRequest(TransactionRequest request, String ... args) {
        request.setChaincodeID(this.getChaincodeId());
        request.setFcn(this.name);
        request.setArgs(args);
    }

    private ChaincodeID getChaincodeId() {
        return ChaincodeID.newBuilder().setName(this.contract.getChaincodeId()).build();
    }

    private Collection<ProposalResponse> validatePeerResponses(Collection<ProposalResponse> proposalResponses) throws ContractException {
        ArrayList<ProposalResponse> validResponses = new ArrayList<ProposalResponse>();
        ArrayList invalidResponseMsgs = new ArrayList();
        proposalResponses.forEach(response -> {
            String peerUrl;
            String string = peerUrl = response.getPeer() != null ? response.getPeer().getUrl() : "<unknown>";
            if (response.getStatus().equals((Object)ChaincodeResponse.Status.SUCCESS)) {
                LOG.debug((Object)String.format("validatePeerResponses: valid response from peer %s", peerUrl));
                validResponses.add((ProposalResponse)response);
            } else {
                LOG.warn((Object)String.format("validatePeerResponses: invalid response from peer %s, message %s", peerUrl, response.getMessage()));
                invalidResponseMsgs.add(response.getMessage());
            }
        });
        if (validResponses.size() < 1) {
            String msg = String.format("No valid proposal responses received. %d peer error responses: %s", invalidResponseMsgs.size(), String.join((CharSequence)"; ", invalidResponseMsgs));
            LOG.error((Object)msg);
            throw new ContractException(msg, proposalResponses);
        }
        return validResponses;
    }

    @Override
    public byte[] evaluate(String ... args) throws ContractException {
        QueryByChaincodeRequest request = this.newQueryRequest(args);
        QueryImpl query = new QueryImpl(this.network.getChannel(), request);
        ProposalResponse response = this.queryHandler.evaluate(query);
        try {
            return response.getChaincodeActionResponsePayload();
        }
        catch (InvalidArgumentException e) {
            throw new ContractException(response.getMessage(), e);
        }
    }

    private QueryByChaincodeRequest newQueryRequest(String ... args) {
        QueryByChaincodeRequest request = this.gateway.getClient().newQueryProposalRequest();
        this.configureRequest((TransactionRequest)request, args);
        if (this.transientData != null) {
            try {
                request.setTransientMap(this.transientData);
            }
            catch (InvalidArgumentException e) {
                throw new IllegalStateException(e);
            }
        }
        return request;
    }
}

