/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.commit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.hyperledger.fabric.gateway.ContractException;
import org.hyperledger.fabric.gateway.Network;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.impl.commit.CommitStrategy;
import org.hyperledger.fabric.gateway.spi.CommitHandler;
import org.hyperledger.fabric.gateway.spi.CommitListener;
import org.hyperledger.fabric.gateway.spi.PeerDisconnectEvent;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Peer;

public final class CommitHandlerImpl
implements CommitHandler {
    private final String transactionId;
    private final Network network;
    private final CommitStrategy strategy;
    private final CommitListener listener = new CommitListener(){

        @Override
        public void acceptCommit(BlockEvent.TransactionEvent transactionEvent) {
            CommitHandlerImpl.this.onTxEvent(transactionEvent);
        }

        @Override
        public void acceptDisconnect(PeerDisconnectEvent disconnectEvent) {
            CommitHandlerImpl.this.onDisconnectEvent(disconnectEvent);
        }
    };
    private final Set<Peer> peers;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<ContractException> error = new AtomicReference();

    public CommitHandlerImpl(String transactionId, Network network, CommitStrategy strategy) {
        this.transactionId = transactionId;
        this.network = network;
        this.strategy = strategy;
        this.peers = Collections.synchronizedSet(new HashSet<Peer>(strategy.getPeers()));
    }

    @Override
    public void startListening() {
        if (this.peers.isEmpty()) {
            this.cancelListening();
        } else {
            this.network.addCommitListener(this.listener, this.peers, this.transactionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForEvents(long timeout, TimeUnit timeUnit) throws ContractException, TimeoutException, InterruptedException {
        try {
            boolean complete = this.latch.await(timeout, timeUnit);
            if (!complete) {
                throw new TimeoutException("Timeout waiting for commit of transaction " + this.transactionId);
            }
        }
        finally {
            this.cancelListening();
        }
        ContractException cause = this.error.get();
        if (cause != null) {
            throw cause;
        }
    }

    @Override
    public void cancelListening() {
        this.latch.countDown();
        this.network.removeCommitListener(this.listener);
        this.peers.clear();
    }

    public String toString() {
        return GatewayUtils.toString(this, "transactionId=" + this.transactionId, "strategy=" + this.strategy, "peers=" + this.peers);
    }

    private void onTxEvent(BlockEvent.TransactionEvent event) {
        if (!this.transactionId.equals(event.getTransactionID()) || !this.peers.remove(event.getPeer())) {
            return;
        }
        if (event.isValid()) {
            CommitStrategy.Result result = this.strategy.onEvent(event);
            this.processStrategyResult(result);
        } else {
            String peerName = event.getPeer().getName();
            this.fail(new ContractException("Transaction commit was rejected by peer " + peerName));
        }
    }

    private void onDisconnectEvent(PeerDisconnectEvent event) {
        if (!this.peers.remove(event.getPeer())) {
            return;
        }
        CommitStrategy.Result result = this.strategy.onError(event);
        this.processStrategyResult(result);
    }

    private void processStrategyResult(CommitStrategy.Result strategyResult) {
        if (strategyResult == CommitStrategy.Result.SUCCESS) {
            this.cancelListening();
        } else if (strategyResult == CommitStrategy.Result.FAIL) {
            this.fail(new ContractException("Commit strategy failed"));
        }
    }

    private void fail(ContractException e) {
        this.error.set(e);
        this.cancelListening();
    }
}

