/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.identity;

import com.ibm.cloud.cloudant.v1.Cloudant;
import com.ibm.cloud.cloudant.v1.model.AllDocsResult;
import com.ibm.cloud.cloudant.v1.model.DeleteDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DocsResultRow;
import com.ibm.cloud.cloudant.v1.model.Document;
import com.ibm.cloud.cloudant.v1.model.GetDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PostAllDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PutDatabaseOptions;
import com.ibm.cloud.cloudant.v1.model.PutDocumentOptions;
import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.BasicAuthenticator;
import com.ibm.cloud.sdk.core.service.exception.NotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.spi.WalletStore;

public final class CloudantWalletStore
implements WalletStore {
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final String DATA_FIELD = "data";
    private final Cloudant service;
    private final String databaseName;

    private CloudantWalletStore(Cloudant service, String databaseName) {
        this.service = service;
        this.databaseName = databaseName;
    }

    public static CloudantWalletStore newInstance(URL serverUrl, String databaseName) {
        Cloudant service = CloudantWalletStore.newCloudantService(serverUrl.getUserInfo());
        service.setServiceUrl(serverUrl.toString());
        CloudantWalletStore store = new CloudantWalletStore(service, databaseName);
        try {
            store.createDatabase();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return store;
    }

    private static Cloudant newCloudantService(String userInfo) {
        if (null == userInfo || userInfo.isEmpty()) {
            return Cloudant.newInstance();
        }
        BasicAuthenticator.Builder authBuilder = new BasicAuthenticator.Builder();
        int separatorIndex = userInfo.indexOf(58);
        if (separatorIndex >= 0) {
            String user = userInfo.substring(0, separatorIndex);
            String password = userInfo.substring(separatorIndex + 1);
            authBuilder.username(user).password(password);
        } else {
            authBuilder.username(userInfo);
        }
        return new Cloudant("cloudant", (Authenticator)authBuilder.build());
    }

    private void createDatabase() throws IOException {
        boolean exists = ((List)this.execute(Cloudant::getAllDbs).getResult()).contains(this.databaseName);
        if (!exists) {
            PutDatabaseOptions options = new PutDatabaseOptions.Builder().db(this.databaseName).build();
            this.execute(service -> service.putDatabase(options));
        }
    }

    @Override
    public void remove(String label) throws IOException {
        IdentityDocument document = this.getDocument(label);
        if (null == document) {
            return;
        }
        DeleteDocumentOptions options = new DeleteDocumentOptions.Builder().db(this.databaseName).docId(document.id).rev(document.rev).build();
        this.execute(service -> service.deleteDocument(options));
    }

    private IdentityDocument getDocument(String label) throws IOException {
        GetDocumentOptions options = new GetDocumentOptions.Builder().db(this.databaseName).docId(label).build();
        try {
            Document document = (Document)this.service.getDocument(options).execute().getResult();
            return new IdentityDocument(document);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private <T> Response<T> execute(Function<Cloudant, ServiceCall<T>> call) throws IOException {
        try {
            return call.apply(this.service).execute();
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public InputStream get(String label) throws IOException {
        IdentityDocument document = this.getDocument(label);
        return document != null ? document.getData() : null;
    }

    @Override
    public Set<String> list() throws IOException {
        PostAllDocsOptions options = new PostAllDocsOptions.Builder().db(this.databaseName).build();
        return ((AllDocsResult)this.execute(service -> service.postAllDocs(options)).getResult()).getRows().stream().map(DocsResultRow::getId).collect(Collectors.toSet());
    }

    @Override
    public void put(String label, InputStream data) throws IOException {
        IdentityDocument document = this.getDocument(label);
        if (document != null) {
            document.setData(data);
        } else {
            document = new IdentityDocument(label, data);
        }
        PutDocumentOptions options = new PutDocumentOptions.Builder().db(this.databaseName).docId(document.id).document(document.toDocument()).build();
        this.execute(service -> service.putDocument(options)).getResult();
    }

    private static final class IdentityDocument {
        private final String id;
        private final String rev;
        private String data;

        IdentityDocument(String id, InputStream dataIn) throws IOException {
            this.id = id;
            this.rev = null;
            this.setData(dataIn);
        }

        IdentityDocument(Document document) {
            this.id = document.getId();
            this.rev = document.getRev();
            this.data = (String)document.get(CloudantWalletStore.DATA_FIELD);
        }

        public InputStream getData() {
            return new ByteArrayInputStream(this.data.getBytes(ENCODING));
        }

        public void setData(InputStream dataIn) throws IOException {
            try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
                GatewayUtils.copy(dataIn, byteOut);
                this.data = new String(byteOut.toByteArray(), ENCODING);
            }
        }

        public Document toDocument() {
            Document.Builder builder = new Document.Builder().id(this.id);
            if (this.rev != null) {
                builder.rev(this.rev);
            }
            if (this.data != null) {
                builder.add(CloudantWalletStore.DATA_FIELD, (Object)this.data);
            }
            return builder.build();
        }
    }
}

