/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.hyperledger.fabric.gateway.Contract;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.Network;
import org.hyperledger.fabric.gateway.impl.ContractImpl;
import org.hyperledger.fabric.gateway.impl.GatewayImpl;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.impl.event.BlockEventSource;
import org.hyperledger.fabric.gateway.impl.event.BlockEventSourceFactory;
import org.hyperledger.fabric.gateway.impl.event.BlockListenerSession;
import org.hyperledger.fabric.gateway.impl.event.CommitListenerSession;
import org.hyperledger.fabric.gateway.impl.event.ListenerSession;
import org.hyperledger.fabric.gateway.impl.event.Listeners;
import org.hyperledger.fabric.gateway.impl.event.OrderedBlockEventSource;
import org.hyperledger.fabric.gateway.impl.event.ReplayListenerSession;
import org.hyperledger.fabric.gateway.spi.Checkpointer;
import org.hyperledger.fabric.gateway.spi.CommitListener;
import org.hyperledger.fabric.gateway.spi.QueryHandler;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.TransactionException;

public final class NetworkImpl
implements Network,
AutoCloseable {
    private final Channel channel;
    private final GatewayImpl gateway;
    private final Map<String, Contract> contracts = new ConcurrentHashMap<String, Contract>();
    private final BlockEventSource channelBlockSource;
    private final BlockEventSource orderedBlockSource;
    private final QueryHandler queryHandler;
    private final Map<Consumer<BlockEvent>, ListenerSession> blockListenerSessions = new HashMap<Consumer<BlockEvent>, ListenerSession>();
    private final Map<CommitListener, CommitListenerSession> commitListenerSessions = new ConcurrentHashMap<CommitListener, CommitListenerSession>();

    NetworkImpl(Channel channel, GatewayImpl gateway) {
        this.channel = channel;
        this.gateway = gateway;
        this.initializeChannel();
        this.channelBlockSource = BlockEventSourceFactory.getInstance().newBlockEventSource(channel);
        this.orderedBlockSource = new OrderedBlockEventSource(this.channelBlockSource);
        this.queryHandler = gateway.getQueryHandlerFactory().create(this);
    }

    private void initializeChannel() {
        try {
            this.channel.initialize();
        }
        catch (InvalidArgumentException | TransactionException e) {
            throw new GatewayRuntimeException("Failed to initialize channel", e);
        }
    }

    @Override
    public Contract getContract(String chaincodeId, String name) {
        if (chaincodeId == null || chaincodeId.isEmpty()) {
            throw new IllegalArgumentException("getContract: chaincodeId must be a non-empty string");
        }
        if (name == null) {
            throw new IllegalArgumentException("getContract: name must not be null");
        }
        String key = chaincodeId + ':' + name;
        return this.contracts.computeIfAbsent(key, k -> new ContractImpl(this, chaincodeId, name));
    }

    @Override
    public Contract getContract(String chaincodeId) {
        return this.getContract(chaincodeId, "");
    }

    @Override
    public GatewayImpl getGateway() {
        return this.gateway;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<BlockEvent> addBlockListener(Consumer<BlockEvent> listener) {
        Map<Consumer<BlockEvent>, ListenerSession> map = this.blockListenerSessions;
        synchronized (map) {
            this.blockListenerSessions.computeIfAbsent(listener, k -> new BlockListenerSession(this.orderedBlockSource, listener));
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<BlockEvent> addBlockListener(Checkpointer checkpointer, Consumer<BlockEvent> listener) throws IOException {
        Map<Consumer<BlockEvent>, ListenerSession> map = this.blockListenerSessions;
        synchronized (map) {
            if (!this.blockListenerSessions.containsKey(listener)) {
                Consumer<BlockEvent> checkpointListener = Listeners.checkpointBlock(checkpointer, listener);
                ListenerSession session = this.newCheckpointListenerSession(checkpointer, checkpointListener);
                this.blockListenerSessions.put(listener, session);
            }
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer<BlockEvent> addBlockListener(long startBlock, Consumer<BlockEvent> listener) {
        Map<Consumer<BlockEvent>, ListenerSession> map = this.blockListenerSessions;
        synchronized (map) {
            if (!this.blockListenerSessions.containsKey(listener)) {
                ReplayListenerSession session = new ReplayListenerSession(this, listener, startBlock);
                this.blockListenerSessions.put(listener, session);
            }
        }
        return listener;
    }

    public ListenerSession newCheckpointListenerSession(Checkpointer checkpointer, Consumer<BlockEvent> listener) throws IOException {
        long blockNumber = checkpointer.getBlockNumber();
        if (blockNumber == -1L) {
            return new BlockListenerSession(this.orderedBlockSource, listener);
        }
        return new ReplayListenerSession(this, listener, blockNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlockListener(Consumer<BlockEvent> listener) {
        ListenerSession session;
        Map<Consumer<BlockEvent>, ListenerSession> map = this.blockListenerSessions;
        synchronized (map) {
            session = this.blockListenerSessions.remove(listener);
        }
        if (session != null) {
            session.close();
        }
    }

    @Override
    public CommitListener addCommitListener(CommitListener listener, Collection<Peer> peers, String transactionId) {
        this.commitListenerSessions.computeIfAbsent(listener, k -> new CommitListenerSession(this.channelBlockSource, listener, peers, transactionId));
        return listener;
    }

    @Override
    public void removeCommitListener(CommitListener listener) {
        CommitListenerSession session = this.commitListenerSessions.remove(listener);
        if (session != null) {
            session.close();
        }
    }

    public QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    public BlockEventSource getBlockSource() {
        return this.orderedBlockSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Consumer<BlockEvent>, ListenerSession> map = this.blockListenerSessions;
        synchronized (map) {
            this.blockListenerSessions.values().forEach(ListenerSession::close);
            this.blockListenerSessions.clear();
        }
        this.commitListenerSessions.values().forEach(ListenerSession::close);
        this.commitListenerSessions.clear();
        this.orderedBlockSource.close();
        this.channelBlockSource.close();
        this.channel.shutdown(this.gateway.isForceClose());
    }

    public String toString() {
        return GatewayUtils.toString(this, "name=" + this.channel.getName(), "channelBlockSource=" + this.channelBlockSource, "commitListenerSessions=" + this.commitListenerSessions, "orderedBlockSource=" + this.orderedBlockSource, "blockListenerSessions=" + this.blockListenerSessions);
    }
}

