/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.hyperledger.fabric.gateway.impl.GatewayUtils;
import org.hyperledger.fabric.gateway.impl.event.BlockEventSource;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;

public final class ChannelBlockEventSource
implements BlockEventSource {
    private final Map<Consumer<BlockEvent>, String> handleMap = new ConcurrentHashMap<Consumer<BlockEvent>, String>();
    private final Channel channel;

    ChannelBlockEventSource(Channel channel) {
        this.channel = channel;
    }

    @Override
    public Consumer<BlockEvent> addBlockListener(Consumer<BlockEvent> listener) {
        this.handleMap.computeIfAbsent(listener, this::registerChannelListener);
        return listener;
    }

    private String registerChannelListener(Consumer<BlockEvent> listener) {
        try {
            return this.channel.registerBlockListener(listener::accept);
        }
        catch (InvalidArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void removeBlockListener(Consumer<BlockEvent> listener) {
        this.handleMap.computeIfPresent(listener, (key, value) -> {
            this.unregisterChannelListener((String)value);
            return null;
        });
    }

    private void unregisterChannelListener(String handle) {
        try {
            this.channel.unregisterBlockListener(handle);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.handleMap.forEach((listener, handle) -> this.removeBlockListener((Consumer<BlockEvent>)listener));
    }

    public String toString() {
        return GatewayUtils.toString(this, "channel=" + this.channel);
    }
}

