/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import io.grpc.CallOptions;
import java.util.function.UnaryOperator;
import org.hyperledger.fabric.client.Commit;
import org.hyperledger.fabric.client.CommitStatusException;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.Status;
import org.hyperledger.fabric.client.StatusImpl;
import org.hyperledger.fabric.protos.gateway.CommitStatusResponse;
import org.hyperledger.fabric.protos.gateway.SignedCommitStatusRequest;

class CommitImpl
implements Commit {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String transactionId;
    private SignedCommitStatusRequest signedRequest;

    CommitImpl(GatewayClient client, SigningIdentity signingIdentity, String transactionId, SignedCommitStatusRequest signedRequest) {
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.transactionId = transactionId;
        this.signedRequest = signedRequest;
    }

    @Override
    public byte[] getBytes() {
        return this.signedRequest.toByteArray();
    }

    @Override
    public byte[] getDigest() {
        byte[] message = this.signedRequest.getRequest().toByteArray();
        return this.signingIdentity.hash(message);
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public Status getStatus(UnaryOperator<CallOptions> options) throws CommitStatusException {
        this.sign();
        CommitStatusResponse response = this.client.commitStatus(this.signedRequest, options);
        return new StatusImpl(this.transactionId, response);
    }

    void setSignature(byte[] signature) {
        this.signedRequest = this.signedRequest.toBuilder().setSignature(ByteString.copyFrom((byte[])signature)).build();
    }

    private void sign() {
        if (this.isSigned()) {
            return;
        }
        byte[] digest = this.getDigest();
        byte[] signature = this.signingIdentity.sign(digest);
        this.setSignature(signature);
    }

    private boolean isSigned() {
        return !this.signedRequest.getSignature().isEmpty();
    }
}

