/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.hyperledger.fabric.client.CloseableIterator;
import org.hyperledger.fabric.client.CommitStatusException;
import org.hyperledger.fabric.client.DefaultCallOptions;
import org.hyperledger.fabric.client.EndorseException;
import org.hyperledger.fabric.client.GatewayException;
import org.hyperledger.fabric.client.GatewayRuntimeException;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.client.SubmitException;
import org.hyperledger.fabric.protos.common.Envelope;
import org.hyperledger.fabric.protos.gateway.ChaincodeEventsResponse;
import org.hyperledger.fabric.protos.gateway.CommitStatusRequest;
import org.hyperledger.fabric.protos.gateway.CommitStatusResponse;
import org.hyperledger.fabric.protos.gateway.EndorseRequest;
import org.hyperledger.fabric.protos.gateway.EndorseResponse;
import org.hyperledger.fabric.protos.gateway.EvaluateRequest;
import org.hyperledger.fabric.protos.gateway.EvaluateResponse;
import org.hyperledger.fabric.protos.gateway.GatewayGrpc;
import org.hyperledger.fabric.protos.gateway.SignedChaincodeEventsRequest;
import org.hyperledger.fabric.protos.gateway.SignedCommitStatusRequest;
import org.hyperledger.fabric.protos.gateway.SubmitRequest;
import org.hyperledger.fabric.protos.gateway.SubmitResponse;
import org.hyperledger.fabric.protos.peer.DeliverGrpc;
import org.hyperledger.fabric.protos.peer.DeliverResponse;

final class GatewayClient {
    private final GatewayGrpc.GatewayBlockingStub gatewayBlockingStub;
    private final DeliverGrpc.DeliverStub deliverAsyncStub;
    private final DefaultCallOptions defaultOptions;

    GatewayClient(Channel channel, DefaultCallOptions defaultOptions) {
        GatewayUtils.requireNonNullArgument(channel, "No connection details supplied");
        GatewayUtils.requireNonNullArgument(defaultOptions, "defaultOptions");
        this.gatewayBlockingStub = GatewayGrpc.newBlockingStub((Channel)channel);
        this.deliverAsyncStub = DeliverGrpc.newStub((Channel)channel);
        this.defaultOptions = defaultOptions;
    }

    public EvaluateResponse evaluate(EvaluateRequest request, UnaryOperator<CallOptions> options) throws GatewayException {
        GatewayGrpc.GatewayBlockingStub stub = this.defaultOptions.applyEvaluate(this.gatewayBlockingStub, options);
        try {
            return stub.evaluate(request);
        }
        catch (StatusRuntimeException e) {
            throw new GatewayException(e);
        }
    }

    public EndorseResponse endorse(EndorseRequest request, UnaryOperator<CallOptions> options) throws EndorseException {
        GatewayGrpc.GatewayBlockingStub stub = this.defaultOptions.applyEndorse(this.gatewayBlockingStub, options);
        try {
            return stub.endorse(request);
        }
        catch (StatusRuntimeException e) {
            throw new EndorseException(request.getTransactionId(), e);
        }
    }

    public SubmitResponse submit(SubmitRequest request, UnaryOperator<CallOptions> options) throws SubmitException {
        GatewayGrpc.GatewayBlockingStub stub = this.defaultOptions.applySubmit(this.gatewayBlockingStub, options);
        try {
            return stub.submit(request);
        }
        catch (StatusRuntimeException e) {
            throw new SubmitException(request.getTransactionId(), e);
        }
    }

    public CommitStatusResponse commitStatus(SignedCommitStatusRequest request, UnaryOperator<CallOptions> options) throws CommitStatusException {
        GatewayGrpc.GatewayBlockingStub stub = this.defaultOptions.applyCommitStatus(this.gatewayBlockingStub, options);
        try {
            return stub.commitStatus(request);
        }
        catch (StatusRuntimeException e) {
            try {
                CommitStatusRequest req = CommitStatusRequest.parseFrom((ByteString)request.getRequest());
                throw new CommitStatusException(req.getTransactionId(), e);
            }
            catch (InvalidProtocolBufferException protoErr) {
                CommitStatusException commitErr = new CommitStatusException("", e);
                commitErr.addSuppressed(protoErr);
                throw commitErr;
            }
        }
    }

    public CloseableIterator<ChaincodeEventsResponse> chaincodeEvents(SignedChaincodeEventsRequest request, UnaryOperator<CallOptions> options) {
        GatewayGrpc.GatewayBlockingStub stub = this.defaultOptions.applyChaincodeEvents(this.gatewayBlockingStub, options);
        return this.invokeServerStreamingCall(() -> stub.chaincodeEvents(request));
    }

    public CloseableIterator<DeliverResponse> blockEvents(Envelope request, UnaryOperator<CallOptions> options) {
        DeliverGrpc.DeliverStub stub = this.defaultOptions.applyBlockEvents(this.deliverAsyncStub, options);
        return this.invokeDuplexStreamingCall(arg_0 -> ((DeliverGrpc.DeliverStub)stub).deliver(arg_0), request);
    }

    public CloseableIterator<DeliverResponse> filteredBlockEvents(Envelope request, UnaryOperator<CallOptions> options) {
        DeliverGrpc.DeliverStub stub = this.defaultOptions.applyFilteredBlockEvents(this.deliverAsyncStub, options);
        return this.invokeDuplexStreamingCall(arg_0 -> ((DeliverGrpc.DeliverStub)stub).deliverFiltered(arg_0), request);
    }

    public CloseableIterator<DeliverResponse> blockAndPrivateDataEvents(Envelope request, UnaryOperator<CallOptions> options) {
        DeliverGrpc.DeliverStub stub = this.defaultOptions.applyBlockAndPrivateDataEvents(this.deliverAsyncStub, options);
        return this.invokeDuplexStreamingCall(arg_0 -> ((DeliverGrpc.DeliverStub)stub).deliverWithPrivateData(arg_0), request);
    }

    private <Response> CloseableIterator<Response> invokeServerStreamingCall(Supplier<Iterator<Response>> call) {
        Context.CancellableContext context = Context.current().withCancellation();
        return this.invokeStreamingCall(context, call);
    }

    private <Response> CloseableIterator<Response> invokeStreamingCall(Context.CancellableContext context, Supplier<Iterator<Response>> call) {
        try {
            Iterator iterator = (Iterator)context.wrap(call::get).call();
            return new ResponseIterator(context, iterator);
        }
        catch (StatusRuntimeException e) {
            context.cancel((Throwable)e);
            throw new GatewayRuntimeException(e);
        }
        catch (RuntimeException e) {
            context.cancel((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            context.cancel((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private <Request, Response> CloseableIterator<Response> invokeDuplexStreamingCall(Function<StreamObserver<Response>, StreamObserver<Request>> call, Request request) {
        ResponseObserver responseObserver = new ResponseObserver();
        Context.CancellableContext context = Context.current().withCancellation();
        context.addListener(context1 -> responseObserver.onCompleted(), Runnable::run);
        return this.invokeStreamingCall(context, () -> {
            StreamObserver requestObserver = (StreamObserver)call.apply(responseObserver);
            requestObserver.onNext(request);
            return responseObserver;
        });
    }

    private static final class ResponseIterator<T>
    implements CloseableIterator<T> {
        private final Context.CancellableContext context;
        private final Iterator<T> iterator;

        ResponseIterator(Context.CancellableContext context, Iterator<T> iterator) {
            this.context = context;
            this.iterator = iterator;
        }

        @Override
        public void close() {
            this.context.close();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (StatusRuntimeException e) {
                throw new GatewayRuntimeException(e);
            }
        }

        @Override
        public T next() {
            try {
                return this.iterator.next();
            }
            catch (StatusRuntimeException e) {
                throw new GatewayRuntimeException(e);
            }
        }
    }

    private static final class ResponseObserver<T>
    implements StreamObserver<T>,
    Iterator<T> {
        private final LinkedTransferQueue<Supplier<T>> queue = new LinkedTransferQueue();
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private Supplier<T> next;

        private ResponseObserver() {
        }

        public void onNext(T response) {
            Future<?> future = this.executor.submit(() -> this.transfer(response));
            try {
                future.get();
            }
            catch (InterruptedException | CancellationException exception) {
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private void transfer(T response) {
            try {
                this.queue.transfer(() -> response);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }

        public void onError(Throwable t) {
            StatusRuntimeException err = t instanceof StatusRuntimeException ? (StatusRuntimeException)t : Status.fromThrowable((Throwable)t).asRuntimeException();
            this.queue.put(() -> {
                throw err;
            });
        }

        public void onCompleted() {
            this.queue.put(() -> null);
            List liveTasks = this.executor.shutdownNow().stream().filter(waitingTask -> {
                if (!(waitingTask instanceof Future)) {
                    return true;
                }
                Future future = (Future)((Object)waitingTask);
                future.cancel(true);
                return !future.isCancelled();
            }).collect(Collectors.toList());
            if (!liveTasks.isEmpty()) {
                throw new IllegalStateException("Failed to cancel tasks: " + liveTasks);
            }
        }

        @Override
        public boolean hasNext() {
            return this.readNext().get() != null;
        }

        @Override
        public T next() {
            T result = this.readNext().get();
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return result;
        }

        private Supplier<T> readNext() {
            if (this.next == null) {
                try {
                    this.next = this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new NoSuchElementException();
                }
            }
            return this.next;
        }
    }
}

