/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.CharArrayWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.hyperledger.fabric.client.GrpcStatus;
import org.hyperledger.fabric.protos.gateway.ErrorDetail;

public class GatewayException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final transient GrpcStatus grpcStatus;

    public GatewayException(StatusRuntimeException cause) {
        super(cause);
        this.grpcStatus = new GrpcStatus(cause.getStatus(), cause.getTrailers());
    }

    public Status getStatus() {
        return this.grpcStatus.getStatus();
    }

    public List<ErrorDetail> getDetails() {
        return this.grpcStatus.getDetails();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        this.printStackTrace(new PrintWriter(out));
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        CharArrayWriter message = new CharArrayWriter();
        try (PrintWriter printer = new PrintWriter(message);){
            super.printStackTrace(printer);
            printer.flush();
        }
        List<ErrorDetail> details = this.getDetails();
        if (!details.isEmpty()) {
            message.append("Error details:\n");
            for (ErrorDetail detail : details) {
                message.append("    address: ").append(detail.getAddress()).append("; mspId: ").append(detail.getMspId()).append("; message: ").append(detail.getMessage()).append('\n');
            }
        }
        out.print(message);
    }
}

