/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.CallOptions;
import io.grpc.Channel;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.hyperledger.fabric.client.BlockAndPrivateDataEventsRequest;
import org.hyperledger.fabric.client.BlockAndPrivateDataEventsRequestImpl;
import org.hyperledger.fabric.client.BlockEventsRequest;
import org.hyperledger.fabric.client.BlockEventsRequestImpl;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.ChaincodeEventsRequestImpl;
import org.hyperledger.fabric.client.Commit;
import org.hyperledger.fabric.client.CommitImpl;
import org.hyperledger.fabric.client.DefaultCallOptions;
import org.hyperledger.fabric.client.FilteredBlockEventsRequest;
import org.hyperledger.fabric.client.FilteredBlockEventsRequestImpl;
import org.hyperledger.fabric.client.Gateway;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.Hash;
import org.hyperledger.fabric.client.Network;
import org.hyperledger.fabric.client.NetworkImpl;
import org.hyperledger.fabric.client.Proposal;
import org.hyperledger.fabric.client.ProposalImpl;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.Transaction;
import org.hyperledger.fabric.client.TransactionImpl;
import org.hyperledger.fabric.client.identity.Identity;
import org.hyperledger.fabric.client.identity.Signer;
import org.hyperledger.fabric.protos.common.ChannelHeader;
import org.hyperledger.fabric.protos.common.Envelope;
import org.hyperledger.fabric.protos.common.Header;
import org.hyperledger.fabric.protos.gateway.CommitStatusRequest;
import org.hyperledger.fabric.protos.gateway.PreparedTransaction;
import org.hyperledger.fabric.protos.gateway.ProposedTransaction;
import org.hyperledger.fabric.protos.gateway.SignedChaincodeEventsRequest;
import org.hyperledger.fabric.protos.gateway.SignedCommitStatusRequest;

final class GatewayImpl
implements Gateway {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;

    private GatewayImpl(Builder builder) {
        this.signingIdentity = new SigningIdentity(builder.identity, builder.hash, builder.signer);
        this.client = new GatewayClient(builder.grpcChannel, builder.optionsBuilder.build());
    }

    @Override
    public Identity getIdentity() {
        return this.signingIdentity.getIdentity();
    }

    @Override
    public void close() {
    }

    @Override
    public Network getNetwork(String networkName) {
        return new NetworkImpl(this.client, this.signingIdentity, networkName);
    }

    @Override
    public Proposal newSignedProposal(byte[] bytes, byte[] signature) {
        ProposalImpl result = this.newProposal(bytes);
        result.setSignature(signature);
        return result;
    }

    @Override
    public ProposalImpl newProposal(byte[] bytes) {
        try {
            ProposedTransaction proposedTransaction = ProposedTransaction.parseFrom((byte[])bytes);
            org.hyperledger.fabric.protos.peer.Proposal proposal = org.hyperledger.fabric.protos.peer.Proposal.parseFrom((ByteString)proposedTransaction.getProposal().getProposalBytes());
            Header header = Header.parseFrom((ByteString)proposal.getHeader());
            ChannelHeader channelHeader = ChannelHeader.parseFrom((ByteString)header.getChannelHeader());
            return new ProposalImpl(this.client, this.signingIdentity, channelHeader.getChannelId(), proposedTransaction);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Transaction newSignedTransaction(byte[] bytes, byte[] signature) {
        TransactionImpl transaction = this.newTransaction(bytes);
        transaction.setSignature(signature);
        return transaction;
    }

    @Override
    public TransactionImpl newTransaction(byte[] bytes) {
        try {
            PreparedTransaction preparedTransaction = PreparedTransaction.parseFrom((byte[])bytes);
            return new TransactionImpl(this.client, this.signingIdentity, preparedTransaction);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Commit newSignedCommit(byte[] bytes, byte[] signature) {
        CommitImpl commit = this.newCommit(bytes);
        commit.setSignature(signature);
        return commit;
    }

    @Override
    public CommitImpl newCommit(byte[] bytes) {
        try {
            SignedCommitStatusRequest signedRequest = SignedCommitStatusRequest.parseFrom((byte[])bytes);
            CommitStatusRequest request = CommitStatusRequest.parseFrom((ByteString)signedRequest.getRequest());
            return new CommitImpl(this.client, this.signingIdentity, request.getTransactionId(), signedRequest);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ChaincodeEventsRequest newSignedChaincodeEventsRequest(byte[] bytes, byte[] signature) {
        ChaincodeEventsRequestImpl result = this.newChaincodeEventsRequest(bytes);
        result.setSignature(signature);
        return result;
    }

    @Override
    public ChaincodeEventsRequestImpl newChaincodeEventsRequest(byte[] bytes) {
        try {
            SignedChaincodeEventsRequest signedRequest = SignedChaincodeEventsRequest.parseFrom((byte[])bytes);
            return new ChaincodeEventsRequestImpl(this.client, this.signingIdentity, signedRequest);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public BlockEventsRequest newSignedBlockEventsRequest(byte[] bytes, byte[] signature) {
        BlockEventsRequestImpl result = this.newBlockEventsRequest(bytes);
        result.setSignature(signature);
        return result;
    }

    @Override
    public BlockEventsRequestImpl newBlockEventsRequest(byte[] bytes) {
        try {
            Envelope request = Envelope.parseFrom((byte[])bytes);
            return new BlockEventsRequestImpl(this.client, this.signingIdentity, request);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public FilteredBlockEventsRequest newSignedFilteredBlockEventsRequest(byte[] bytes, byte[] signature) {
        FilteredBlockEventsRequestImpl result = this.newFilteredBlockEventsRequest(bytes);
        result.setSignature(signature);
        return result;
    }

    @Override
    public FilteredBlockEventsRequestImpl newFilteredBlockEventsRequest(byte[] bytes) {
        try {
            Envelope request = Envelope.parseFrom((byte[])bytes);
            return new FilteredBlockEventsRequestImpl(this.client, this.signingIdentity, request);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public BlockAndPrivateDataEventsRequest newSignedBlockAndPrivateDataEventsRequest(byte[] bytes, byte[] signature) {
        BlockAndPrivateDataEventsRequestImpl result = this.newBlockAndPrivateDataEventsRequest(bytes);
        result.setSignature(signature);
        return result;
    }

    @Override
    public BlockAndPrivateDataEventsRequestImpl newBlockAndPrivateDataEventsRequest(byte[] bytes) {
        try {
            Envelope request = Envelope.parseFrom((byte[])bytes);
            return new BlockAndPrivateDataEventsRequestImpl(this.client, this.signingIdentity, request);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final class Builder
    implements Gateway.Builder {
        private static final Signer UNDEFINED_SIGNER = digest -> {
            throw new UnsupportedOperationException("No signing implementation supplied");
        };
        private Channel grpcChannel;
        private Identity identity;
        private Signer signer = UNDEFINED_SIGNER;
        private Function<byte[], byte[]> hash = Hash.SHA256;
        private final DefaultCallOptions.Builder optionsBuilder = DefaultCallOptions.newBuiler();

        @Override
        public Builder connection(Channel grpcChannel) {
            Objects.requireNonNull(grpcChannel, "connection");
            this.grpcChannel = grpcChannel;
            return this;
        }

        @Override
        public Builder identity(Identity identity) {
            Objects.requireNonNull(identity, "identity");
            this.identity = identity;
            return this;
        }

        @Override
        public Builder signer(Signer signer) {
            Objects.requireNonNull(signer, "signer");
            this.signer = signer;
            return this;
        }

        @Override
        public Builder hash(Function<byte[], byte[]> hash) {
            Objects.requireNonNull(hash, "hash");
            this.hash = hash;
            return this;
        }

        @Override
        public Builder evaluateOptions(UnaryOperator<CallOptions> options) {
            Objects.requireNonNull(options, "evaluateOptions");
            this.optionsBuilder.evaluate(options);
            return this;
        }

        @Override
        public Builder endorseOptions(UnaryOperator<CallOptions> options) {
            Objects.requireNonNull(options, "endorseOptions");
            this.optionsBuilder.endorse(options);
            return this;
        }

        @Override
        public Gateway.Builder submitOptions(UnaryOperator<CallOptions> options) {
            Objects.requireNonNull(options, "submitOptions");
            this.optionsBuilder.submit(options);
            return this;
        }

        @Override
        public Gateway.Builder commitStatusOptions(UnaryOperator<CallOptions> options) {
            Objects.requireNonNull(options, "commitStatusOptions");
            this.optionsBuilder.commitStatus(options);
            return this;
        }

        @Override
        public Gateway.Builder chaincodeEventsOptions(UnaryOperator<CallOptions> options) {
            Objects.requireNonNull(options, "chaincodeEventsOptions");
            this.optionsBuilder.chaincodeEvents(options);
            return this;
        }

        @Override
        public Gateway.Builder blockEventsOptions(UnaryOperator<CallOptions> options) {
            Objects.requireNonNull(options, "blockEventsOptions");
            this.optionsBuilder.blockEvents(options);
            return this;
        }

        @Override
        public Gateway.Builder filteredBlockEventsOptions(UnaryOperator<CallOptions> options) {
            Objects.requireNonNull(options, "filteredBlockEventsOptions");
            this.optionsBuilder.filteredBlockEvents(options);
            return this;
        }

        @Override
        public Gateway.Builder blockAndPrivateDataEventsOptions(UnaryOperator<CallOptions> options) {
            Objects.requireNonNull(options, "blockAndPrivateDataEventsOptions");
            this.optionsBuilder.blockAndPrivateDataEvents(options);
            return this;
        }

        @Override
        public GatewayImpl connect() {
            return new GatewayImpl(this);
        }
    }
}

