/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.CallOptions;
import java.util.NoSuchElementException;
import java.util.function.UnaryOperator;
import org.hyperledger.fabric.client.BlockEventsRequest;
import org.hyperledger.fabric.client.CloseableIterator;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.MappingCloseableIterator;
import org.hyperledger.fabric.client.SignableBlockEventsRequest;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.protos.common.Block;
import org.hyperledger.fabric.protos.common.Envelope;
import org.hyperledger.fabric.protos.peer.DeliverResponse;

final class BlockEventsRequestImpl
extends SignableBlockEventsRequest
implements BlockEventsRequest {
    private final GatewayClient client;

    BlockEventsRequestImpl(GatewayClient client, SigningIdentity signingIdentity, Envelope request) {
        super(signingIdentity, request);
        this.client = client;
    }

    @Override
    public CloseableIterator<Block> getEvents(UnaryOperator<CallOptions> options) {
        Envelope request = this.getSignedRequest();
        CloseableIterator<DeliverResponse> responseIter = this.client.blockEvents(request, options);
        return new MappingCloseableIterator<DeliverResponse, Block>(responseIter, response -> {
            DeliverResponse.TypeCase responseType = response.getTypeCase();
            if (responseType == DeliverResponse.TypeCase.STATUS) {
                throw new NoSuchElementException("Unexpected status response: " + response.getStatus());
            }
            return response.getBlock();
        });
    }
}

