/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import java.util.Objects;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.ChaincodeEventsRequestImpl;
import org.hyperledger.fabric.client.Checkpoint;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.StartPositionBuilder;
import org.hyperledger.fabric.protos.gateway.ChaincodeEventsRequest;
import org.hyperledger.fabric.protos.gateway.SignedChaincodeEventsRequest;

final class ChaincodeEventsBuilder
implements ChaincodeEventsRequest.Builder {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String channelName;
    private final String chaincodeName;
    private final StartPositionBuilder startPositionBuilder = new StartPositionBuilder();
    private String afterTransactionId;

    ChaincodeEventsBuilder(GatewayClient client, SigningIdentity signingIdentity, String channelName, String chaincodeName) {
        Objects.requireNonNull(channelName, "channel name");
        Objects.requireNonNull(chaincodeName, "chaincode name");
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.channelName = channelName;
        this.chaincodeName = chaincodeName;
    }

    @Override
    public ChaincodeEventsRequest.Builder startBlock(long blockNumber) {
        this.startPositionBuilder.startBlock(blockNumber);
        return this;
    }

    @Override
    public ChaincodeEventsRequest.Builder checkpoint(Checkpoint checkpoint) {
        checkpoint.getBlockNumber().ifPresent(this.startPositionBuilder::startBlock);
        this.afterTransactionId = checkpoint.getTransactionId().orElse(null);
        return this;
    }

    @Override
    public ChaincodeEventsRequest build() {
        SignedChaincodeEventsRequest signedRequest = this.newSignedChaincodeEventsRequestProto();
        return new ChaincodeEventsRequestImpl(this.client, this.signingIdentity, signedRequest);
    }

    private SignedChaincodeEventsRequest newSignedChaincodeEventsRequestProto() {
        org.hyperledger.fabric.protos.gateway.ChaincodeEventsRequest request = this.newChaincodeEventsRequestProto();
        return SignedChaincodeEventsRequest.newBuilder().setRequest(request.toByteString()).build();
    }

    private org.hyperledger.fabric.protos.gateway.ChaincodeEventsRequest newChaincodeEventsRequestProto() {
        ByteString creator = ByteString.copyFrom((byte[])this.signingIdentity.getCreator());
        ChaincodeEventsRequest.Builder builder = org.hyperledger.fabric.protos.gateway.ChaincodeEventsRequest.newBuilder().setChannelId(this.channelName).setChaincodeId(this.chaincodeName).setIdentity(creator).setStartPosition(this.startPositionBuilder.build());
        if (this.afterTransactionId != null) {
            builder.setAfterTransactionId(this.afterTransactionId);
        }
        return builder.build();
    }
}

