/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.hyperledger.fabric.client.BlockAndPrivateDataEventsRequest;
import org.hyperledger.fabric.client.BlockEventsRequest;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.ChaincodeEventsRequest;
import org.hyperledger.fabric.client.Commit;
import org.hyperledger.fabric.client.FilteredBlockEventsRequest;
import org.hyperledger.fabric.client.GatewayImpl;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.client.Network;
import org.hyperledger.fabric.client.Proposal;
import org.hyperledger.fabric.client.Transaction;
import org.hyperledger.fabric.client.identity.Identity;
import org.hyperledger.fabric.client.identity.Signer;

public interface Gateway
extends AutoCloseable {
    public static Builder newInstance() {
        return new GatewayImpl.Builder();
    }

    public Identity getIdentity();

    public Network getNetwork(String var1);

    public Proposal newSignedProposal(byte[] var1, byte[] var2);

    public Proposal newProposal(byte[] var1);

    public Transaction newSignedTransaction(byte[] var1, byte[] var2);

    public Transaction newTransaction(byte[] var1);

    public Commit newSignedCommit(byte[] var1, byte[] var2);

    public Commit newCommit(byte[] var1);

    public ChaincodeEventsRequest newSignedChaincodeEventsRequest(byte[] var1, byte[] var2);

    public ChaincodeEventsRequest newChaincodeEventsRequest(byte[] var1);

    public BlockEventsRequest newSignedBlockEventsRequest(byte[] var1, byte[] var2);

    public BlockEventsRequest newBlockEventsRequest(byte[] var1);

    public FilteredBlockEventsRequest newSignedFilteredBlockEventsRequest(byte[] var1, byte[] var2);

    public FilteredBlockEventsRequest newFilteredBlockEventsRequest(byte[] var1);

    public BlockAndPrivateDataEventsRequest newSignedBlockAndPrivateDataEventsRequest(byte[] var1, byte[] var2);

    public BlockAndPrivateDataEventsRequest newBlockAndPrivateDataEventsRequest(byte[] var1);

    @Override
    public void close();

    public static interface Builder {
        public Builder connection(Channel var1);

        public Builder identity(Identity var1);

        public Builder signer(Signer var1);

        public Builder hash(Function<byte[], byte[]> var1);

        public Builder tlsClientCertificateHash(byte[] var1);

        @Deprecated
        default public Builder evaluateOptions(CallOption ... options) {
            return this.evaluateOptions(GatewayUtils.asCallOptions(options));
        }

        public Builder evaluateOptions(UnaryOperator<CallOptions> var1);

        @Deprecated
        default public Builder endorseOptions(CallOption ... options) {
            return this.endorseOptions(GatewayUtils.asCallOptions(options));
        }

        public Builder endorseOptions(UnaryOperator<CallOptions> var1);

        @Deprecated
        default public Builder submitOptions(CallOption ... options) {
            return this.submitOptions(GatewayUtils.asCallOptions(options));
        }

        public Builder submitOptions(UnaryOperator<CallOptions> var1);

        @Deprecated
        default public Builder commitStatusOptions(CallOption ... options) {
            return this.commitStatusOptions(GatewayUtils.asCallOptions(options));
        }

        public Builder commitStatusOptions(UnaryOperator<CallOptions> var1);

        @Deprecated
        default public Builder chaincodeEventsOptions(CallOption ... options) {
            return this.chaincodeEventsOptions(GatewayUtils.asCallOptions(options));
        }

        public Builder chaincodeEventsOptions(UnaryOperator<CallOptions> var1);

        public Builder blockEventsOptions(UnaryOperator<CallOptions> var1);

        public Builder filteredBlockEventsOptions(UnaryOperator<CallOptions> var1);

        public Builder blockAndPrivateDataEventsOptions(UnaryOperator<CallOptions> var1);

        public Gateway connect();
    }
}

