/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client.identity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequenceGenerator;

final class ECSignature {
    private final ASN1Integer r;
    private final ASN1Integer s;

    /*
     * Enabled aggressive exception aggregation
     */
    static ECSignature fromBytes(byte[] derSignature) throws GeneralSecurityException {
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(derSignature);){
            ECSignature eCSignature;
            try (ASN1InputStream asnInputStream = new ASN1InputStream((InputStream)inStream);){
                ASN1Primitive asn1 = asnInputStream.readObject();
                if (!(asn1 instanceof ASN1Sequence)) {
                    throw new GeneralSecurityException("Invalid signature type: " + asn1.getClass().getTypeName());
                }
                ASN1Sequence asn1Sequence = (ASN1Sequence)asn1;
                List signatureParts = StreamSupport.stream(asn1Sequence.spliterator(), false).map(ASN1Encodable::toASN1Primitive).filter(asn1Primitive -> asn1Primitive instanceof ASN1Integer).map(asn1Primitive -> (ASN1Integer)asn1Primitive).collect(Collectors.toList());
                if (signatureParts.size() != 2) {
                    throw new GeneralSecurityException("Invalid signature. Expected 2 values but got " + signatureParts.size());
                }
                eCSignature = new ECSignature((ASN1Integer)signatureParts.get(0), (ASN1Integer)signatureParts.get(1));
            }
            return eCSignature;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    ECSignature(ASN1Integer r, ASN1Integer s) {
        this.r = r;
        this.s = s;
    }

    public ASN1Integer getR() {
        return this.r;
    }

    public ASN1Integer getS() {
        return this.s;
    }

    public byte[] getBytes() {
        byte[] byArray;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try {
            DERSequenceGenerator sequence = new DERSequenceGenerator((OutputStream)bytesOut);
            sequence.addObject((ASN1Primitive)this.r);
            sequence.addObject((ASN1Primitive)this.s);
            sequence.close();
            byArray = bytesOut.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bytesOut.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        bytesOut.close();
        return byArray;
    }
}

