/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.hyperledger.fabric.client.GrpcStackTracePrinter;
import org.hyperledger.fabric.client.GrpcStatus;
import org.hyperledger.fabric.protos.gateway.ErrorDetail;

public class GatewayException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final transient GrpcStatus grpcStatus;

    public GatewayException(StatusRuntimeException cause) {
        super((Throwable)cause);
        this.grpcStatus = new GrpcStatus(cause.getStatus(), cause.getTrailers());
    }

    public Status getStatus() {
        return this.grpcStatus.getStatus();
    }

    public List<ErrorDetail> getDetails() {
        return this.grpcStatus.getDetails();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        new GrpcStackTracePrinter(x$0 -> super.printStackTrace((PrintWriter)x$0), this.grpcStatus).printStackTrace(out);
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        new GrpcStackTracePrinter(x$0 -> super.printStackTrace((PrintWriter)x$0), this.grpcStatus).printStackTrace(out);
    }
}

