/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import io.grpc.CallOptions;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.hyperledger.fabric.client.CallOption;
import org.hyperledger.fabric.client.EndorseException;
import org.hyperledger.fabric.client.GatewayException;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.client.Signable;
import org.hyperledger.fabric.client.Transaction;

public interface Proposal
extends Signable {
    public String getTransactionId();

    default public byte[] evaluate() throws GatewayException {
        return this.evaluate(GatewayUtils.asCallOptions(new CallOption[0]));
    }

    public byte[] evaluate(UnaryOperator<CallOptions> var1) throws GatewayException;

    @Deprecated
    default public byte[] evaluate(CallOption ... options) throws GatewayException {
        return this.evaluate(GatewayUtils.asCallOptions(options));
    }

    default public Transaction endorse() throws EndorseException {
        return this.endorse(GatewayUtils.asCallOptions(new CallOption[0]));
    }

    public Transaction endorse(UnaryOperator<CallOptions> var1) throws EndorseException;

    @Deprecated
    default public Transaction endorse(CallOption ... options) throws EndorseException {
        return this.endorse(GatewayUtils.asCallOptions(options));
    }

    public static interface Builder
    extends org.hyperledger.fabric.client.Builder<Proposal> {
        public Builder addArguments(byte[] ... var1);

        public Builder addArguments(String ... var1);

        public Builder putAllTransient(Map<String, byte[]> var1);

        public Builder putTransient(String var1, byte[] var2);

        public Builder putTransient(String var1, String var2);

        public Builder setEndorsingOrganizations(String ... var1);

        @Override
        public Proposal build();
    }
}

