/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import io.grpc.CallOptions;
import java.util.function.UnaryOperator;
import org.hyperledger.fabric.client.EndorseException;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.GatewayException;
import org.hyperledger.fabric.client.Proposal;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.Transaction;
import org.hyperledger.fabric.client.TransactionImpl;
import org.hyperledger.fabric.protos.gateway.EndorseRequest;
import org.hyperledger.fabric.protos.gateway.EndorseResponse;
import org.hyperledger.fabric.protos.gateway.EvaluateRequest;
import org.hyperledger.fabric.protos.gateway.PreparedTransaction;
import org.hyperledger.fabric.protos.gateway.ProposedTransaction;
import org.hyperledger.fabric.protos.peer.SignedProposal;

final class ProposalImpl
implements Proposal {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String channelName;
    private ProposedTransaction proposedTransaction;

    ProposalImpl(GatewayClient client, SigningIdentity signingIdentity, String channelName, ProposedTransaction proposedTransaction) {
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.channelName = channelName;
        this.proposedTransaction = proposedTransaction;
    }

    @Override
    public String getTransactionId() {
        return this.proposedTransaction.getTransactionId();
    }

    @Override
    public byte[] getBytes() {
        return this.proposedTransaction.toByteArray();
    }

    @Override
    public byte[] getDigest() {
        byte[] message = this.proposedTransaction.getProposal().getProposalBytes().toByteArray();
        return this.signingIdentity.hash(message);
    }

    @Override
    public byte[] evaluate(UnaryOperator<CallOptions> options) throws GatewayException {
        this.sign();
        EvaluateRequest evaluateRequest = EvaluateRequest.newBuilder().setTransactionId(this.proposedTransaction.getTransactionId()).setChannelId(this.channelName).setProposedTransaction(this.proposedTransaction.getProposal()).addAllTargetOrganizations((Iterable)this.proposedTransaction.getEndorsingOrganizationsList()).build();
        return this.client.evaluate(evaluateRequest, options).getResult().getPayload().toByteArray();
    }

    @Override
    public Transaction endorse(UnaryOperator<CallOptions> options) throws EndorseException {
        this.sign();
        EndorseRequest endorseRequest = EndorseRequest.newBuilder().setTransactionId(this.proposedTransaction.getTransactionId()).setChannelId(this.channelName).setProposedTransaction(this.proposedTransaction.getProposal()).addAllEndorsingOrganizations((Iterable)this.proposedTransaction.getEndorsingOrganizationsList()).build();
        EndorseResponse endorseResponse = this.client.endorse(endorseRequest, options);
        PreparedTransaction preparedTransaction = PreparedTransaction.newBuilder().setTransactionId(this.proposedTransaction.getTransactionId()).setEnvelope(endorseResponse.getPreparedTransaction()).build();
        return new TransactionImpl(this.client, this.signingIdentity, preparedTransaction);
    }

    void setSignature(byte[] signature) {
        SignedProposal signedProposal = this.proposedTransaction.getProposal().toBuilder().setSignature(ByteString.copyFrom((byte[])signature)).build();
        this.proposedTransaction = this.proposedTransaction.toBuilder().setProposal(signedProposal).build();
    }

    private void sign() {
        if (this.isSigned()) {
            return;
        }
        byte[] digest = this.getDigest();
        byte[] signature = this.signingIdentity.sign(digest);
        this.setSignature(signature);
    }

    private boolean isSigned() {
        return !this.proposedTransaction.getProposal().getSignature().isEmpty();
    }
}

