/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.bouncycastle.util.encoders.Hex;
import org.hyperledger.fabric.client.GatewayUtils;
import org.hyperledger.fabric.client.Hash;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.protos.common.SignatureHeader;

final class TransactionContext {
    private static final int NONCE_LENGTH = 24;
    private static final SecureRandom RANDOM = new SecureRandom();
    private final SigningIdentity signingIdentity;
    private final byte[] nonce;
    private final String transactionId;
    private final SignatureHeader signatureHeader;

    TransactionContext(SigningIdentity signingIdentity) {
        this.signingIdentity = signingIdentity;
        this.nonce = TransactionContext.newNonce();
        this.transactionId = this.newTransactionId();
        this.signatureHeader = this.newSignatureHeader();
    }

    private static byte[] newNonce() {
        byte[] values = new byte[24];
        RANDOM.nextBytes(values);
        return values;
    }

    private String newTransactionId() {
        byte[] saltedCreator = GatewayUtils.concat(this.nonce, this.signingIdentity.getCreator());
        byte[] rawTransactionId = Hash.SHA256.apply(saltedCreator);
        byte[] hexTransactionId = Hex.encode((byte[])rawTransactionId);
        return new String(hexTransactionId, StandardCharsets.UTF_8);
    }

    private SignatureHeader newSignatureHeader() {
        return SignatureHeader.newBuilder().setCreator(ByteString.copyFrom((byte[])this.signingIdentity.getCreator())).setNonce(ByteString.copyFrom((byte[])this.nonce)).build();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public SignatureHeader getSignatureHeader() {
        return this.signatureHeader;
    }
}

