/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import io.grpc.CallOptions;
import java.util.function.UnaryOperator;
import org.hyperledger.fabric.client.CommitException;
import org.hyperledger.fabric.client.CommitStatusException;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.client.Status;
import org.hyperledger.fabric.client.SubmitException;
import org.hyperledger.fabric.client.SubmittedTransaction;
import org.hyperledger.fabric.client.SubmittedTransactionImpl;
import org.hyperledger.fabric.client.Transaction;
import org.hyperledger.fabric.client.TransactionEnvelopeParser;
import org.hyperledger.fabric.protos.common.Envelope;
import org.hyperledger.fabric.protos.gateway.CommitStatusRequest;
import org.hyperledger.fabric.protos.gateway.PreparedTransaction;
import org.hyperledger.fabric.protos.gateway.SignedCommitStatusRequest;
import org.hyperledger.fabric.protos.gateway.SubmitRequest;

final class TransactionImpl
implements Transaction {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final String channelName;
    private PreparedTransaction preparedTransaction;
    private final ByteString result;

    TransactionImpl(GatewayClient client, SigningIdentity signingIdentity, PreparedTransaction preparedTransaction) {
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.preparedTransaction = preparedTransaction;
        TransactionEnvelopeParser parser = new TransactionEnvelopeParser(preparedTransaction.getEnvelope());
        this.channelName = parser.getChannelName();
        this.result = parser.getResult();
    }

    @Override
    public byte[] getResult() {
        return this.result.toByteArray();
    }

    @Override
    public byte[] getBytes() {
        return this.preparedTransaction.toByteArray();
    }

    @Override
    public byte[] getDigest() {
        byte[] message = this.preparedTransaction.getEnvelope().getPayload().toByteArray();
        return this.signingIdentity.hash(message);
    }

    @Override
    public String getTransactionId() {
        return this.preparedTransaction.getTransactionId();
    }

    @Override
    public byte[] submit(UnaryOperator<CallOptions> options) throws SubmitException, CommitStatusException, CommitException {
        Status status = this.submitAsync(options).getStatus(options);
        if (!status.isSuccessful()) {
            throw new CommitException(status);
        }
        return this.getResult();
    }

    @Override
    public SubmittedTransaction submitAsync(UnaryOperator<CallOptions> options) throws SubmitException {
        this.sign();
        SubmitRequest submitRequest = SubmitRequest.newBuilder().setTransactionId(this.preparedTransaction.getTransactionId()).setChannelId(this.channelName).setPreparedTransaction(this.preparedTransaction.getEnvelope()).build();
        this.client.submit(submitRequest, options);
        return new SubmittedTransactionImpl(this.client, this.signingIdentity, this.getTransactionId(), this.newSignedCommitStatusRequest(), this.result);
    }

    void setSignature(byte[] signature) {
        Envelope envelope = this.preparedTransaction.getEnvelope().toBuilder().setSignature(ByteString.copyFrom((byte[])signature)).build();
        this.preparedTransaction = this.preparedTransaction.toBuilder().setEnvelope(envelope).build();
    }

    private void sign() {
        if (this.isSigned()) {
            return;
        }
        byte[] digest = this.getDigest();
        byte[] signature = this.signingIdentity.sign(digest);
        this.setSignature(signature);
    }

    private boolean isSigned() {
        return !this.preparedTransaction.getEnvelope().getSignature().isEmpty();
    }

    private SignedCommitStatusRequest newSignedCommitStatusRequest() {
        return SignedCommitStatusRequest.newBuilder().setRequest(this.newCommitStatusRequest().toByteString()).build();
    }

    private CommitStatusRequest newCommitStatusRequest() {
        ByteString creator = ByteString.copyFrom((byte[])this.signingIdentity.getCreator());
        return CommitStatusRequest.newBuilder().setChannelId(this.channelName).setTransactionId(this.preparedTransaction.getTransactionId()).setIdentity(creator).build();
    }
}

